/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.HttpClientCallback;
import org.portletbridge.portlet.HttpClientState;
import org.portletbridge.portlet.HttpClientTemplate;

public class DefaultHttpClientTemplate
implements HttpClientTemplate {
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    public Object service(HttpMethodBase method, HttpClientState state, HttpClientCallback callback) throws ResourceException {
        try {
            HostConfiguration hostConfiguration = new HostConfiguration();
            if (state.getProxyHost() != null && state.getProxyHost().trim().length() > 0) {
                hostConfiguration.setProxy(state.getProxyHost(), state.getProxyPort());
            }
            hostConfiguration.setHost(method.getURI());
            int statusCode = this.httpClient.executeMethod(hostConfiguration, (HttpMethod)method, (HttpState)state.getHttpState());
            Object object = callback.doInHttpClient(statusCode, method);
            return object;
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ResourceException("error.httpclient", (Object)e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
    }
}

