/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.TemplateFactory;

public class DefaultTemplateFactory
implements TemplateFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$portlet$DefaultTemplateFactory == null ? (class$org$portletbridge$portlet$DefaultTemplateFactory = DefaultTemplateFactory.class$("org.portletbridge.portlet.DefaultTemplateFactory")) : class$org$portletbridge$portlet$DefaultTemplateFactory));
    private Templates defaultTemplate;
    private String defaultTemplateSytemId;
    private Map templateCache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$portletbridge$portlet$DefaultTemplateFactory;

    public DefaultTemplateFactory() {
        this.defaultTemplateSytemId = this.getClass().getResource("/org/portletbridge/xsl/default.xsl").toExternalForm();
        StreamSource templateSource = new StreamSource(this.defaultTemplateSytemId);
        try {
            this.defaultTemplate = TransformerFactory.newInstance().newTemplates(templateSource);
            log.debug((Object)"created default template");
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Templates getTemplatesFromUrl(String systemId) throws ResourceException, TransformerFactoryConfigurationError {
        if (systemId == null) {
            throw new ResourceException("error.stylesheet");
        }
        Templates result = null;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Templates templates = (Templates)this.templateCache.get(systemId);
            if (templates != null) {
                return templates;
            }
            URL resourceUrl = null;
            if (systemId.startsWith("classpath:")) {
                String substring = systemId.substring(10);
                resourceUrl = this.getClass().getResource(substring);
            } else {
                resourceUrl = new URL(systemId);
            }
            if (resourceUrl == null) {
                throw new ResourceException("error.stylesheet.notfound", (Object)systemId);
            }
            result = factory.newTemplates(new StreamSource(resourceUrl.toExternalForm()));
            this.templateCache.put(systemId, result);
        }
        catch (TransformerConfigurationException e) {
            throw new ResourceException("error.transformer", (Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ResourceException("error.stylesheet.url", (Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Templates getTemplatesFromString(String stylesheet) throws ResourceException, TransformerFactoryConfigurationError {
        if (stylesheet == null || stylesheet.trim().length() == 0) {
            return this.defaultTemplate;
        }
        Templates result = null;
        TransformerFactory factory = TransformerFactory.newInstance();
        final Exception[] exceptionHolder = new Exception[1];
        factory.setErrorListener(new ErrorListener(){

            public void error(TransformerException exception) throws TransformerException {
                exceptionHolder[0] = exception;
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                exceptionHolder[0] = exception;
            }

            public void warning(TransformerException exception) throws TransformerException {
                exceptionHolder[0] = exception;
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(stylesheet.getBytes());
            String key = new String(messageDigest.digest());
            Templates templates = (Templates)this.templateCache.get(key);
            if (templates != null) {
                result = templates;
            } else {
                result = factory.newTemplates(new StreamSource(new StringReader(stylesheet), this.defaultTemplateSytemId));
                this.templateCache.put(key, result);
            }
        }
        catch (TransformerConfigurationException e) {
            exceptionHolder[0] = e;
        }
        catch (NoSuchAlgorithmException e) {
            exceptionHolder[0] = e;
        }
        if (exceptionHolder[0] != null) {
            throw new ResourceException("error.transformer", (Object)exceptionHolder[0].getMessage(), (Throwable)exceptionHolder[0]);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

