/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class IMediaData
extends RefCounted {
    private volatile long swigCPtr;
    private static final long TIME_OFFSET = -Calendar.getInstance().getTimeZone().getRawOffset();
    public static final String DEFAULT_TIME_STAMP_FORMAT = "%1$tH:%1$tM:%1$tS.%1$tL";
    private IBuffer mData;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IMediaData(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIMediaDataUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IMediaData(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIMediaDataUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IMediaData obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IMediaData copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IMediaData(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IMediaData) {
            equal = ((IMediaData)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public void put(byte[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, byte[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(char[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, char[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(short[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, short[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(int[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, int[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(long[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, long[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(float[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, float[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public void put(double[] src, int srcPos, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.put(src, srcPos, destPos, length);
    }

    public void get(int srcPos, double[] dest, int destPos, int length) {
        IBuffer buffer = this.getDataCached();
        if (buffer == null) {
            return;
        }
        buffer.get(srcPos, dest, destPos, length);
    }

    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(null);
    }

    public ByteBuffer getByteBuffer(AtomicReference<JNIReference> ref) {
        IBuffer buf;
        if (ref != null) {
            ref.set(null);
        }
        if ((buf = this.getDataCached()) == null) {
            return null;
        }
        ByteBuffer byteBuffer = buf.getByteBuffer(0, this.getSize(), ref);
        if (byteBuffer != null) {
            byteBuffer.position(0);
            byteBuffer.mark();
            byteBuffer.limit(this.getSize());
        }
        return byteBuffer;
    }

    public String getFormattedTimeStamp() {
        return this.getFormattedTimeStamp(DEFAULT_TIME_STAMP_FORMAT);
    }

    public String getFormattedTimeStamp(String format) {
        Formatter formatter = new Formatter();
        IRational timeBase = this.getTimeBase();
        if (timeBase == null) {
            timeBase = IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND);
        }
        String retval = formatter.format(format, (long)((double)this.getTimeStamp() * timeBase.getDouble() * 1000.0) + TIME_OFFSET).toString();
        timeBase.delete();
        return retval;
    }

    public IBuffer getData() {
        IBuffer retval = this.getData_internal();
        if (retval == null) {
            if (this.mData != null) {
                this.mData.delete();
            }
            this.mData = retval;
        } else if (this.mData == null) {
            this.mData = retval.copyReference();
        } else if (this.mData.getMyCPtr() != retval.getMyCPtr()) {
            this.mData.delete();
            this.mData = retval.copyReference();
        }
        return retval;
    }

    public void setData(IBuffer buffer) {
        if (buffer == null) {
            if (this.mData != null) {
                this.mData.delete();
            }
            this.mData = buffer;
        } else if (this.mData == null) {
            this.mData = buffer.copyReference();
        } else if (this.mData.getMyCPtr() != buffer.getMyCPtr()) {
            this.mData.delete();
            this.mData = buffer.copyReference();
        }
        this.setData_internal(buffer);
    }

    public IBuffer getDataCached() {
        if (this.mData == null) {
            this.mData = this.getData_internal();
        }
        return this.mData;
    }

    @Override
    public void delete() {
        if (this.mData != null) {
            this.mData.delete();
            this.mData = null;
        }
        super.delete();
    }

    public long getTimeStamp() {
        return XugglerJNI.IMediaData_getTimeStamp(this.swigCPtr, this);
    }

    public void setTimeStamp(long aTimeStamp) {
        XugglerJNI.IMediaData_setTimeStamp(this.swigCPtr, this, aTimeStamp);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IMediaData_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setTimeBase(IRational aBase) {
        XugglerJNI.IMediaData_setTimeBase(this.swigCPtr, this, IRational.getCPtr(aBase), aBase);
    }

    protected IBuffer getData_internal() {
        long cPtr = XugglerJNI.IMediaData_getData_internal(this.swigCPtr, this);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public int getSize() {
        return XugglerJNI.IMediaData_getSize(this.swigCPtr, this);
    }

    public boolean isKey() {
        return XugglerJNI.IMediaData_isKey(this.swigCPtr, this);
    }

    protected void setData_internal(IBuffer buffer) {
        XugglerJNI.IMediaData_setData_internal(this.swigCPtr, this, IBuffer.getCPtr(buffer), buffer);
    }
}

