/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.gcube.common.scan.resources.ClasspathResource;

public class JarEntryResource
implements ClasspathResource {
    private final ZipEntry entry;
    private final JarFile file;

    public JarEntryResource(JarFile file, ZipEntry entry) {
        this.file = file;
        this.entry = entry;
    }

    @Override
    public String name() {
        String entryName = this.entry.getName();
        return entryName.substring(entryName.lastIndexOf("/") + 1);
    }

    @Override
    public String path() {
        String path = this.entry.getName();
        if (path.endsWith(".class")) {
            path = path.replace("/", ".");
        }
        return path;
    }

    @Override
    public InputStream stream() throws Exception {
        return this.file.getInputStream(this.entry);
    }

    @Override
    public File file() throws Exception {
        System.out.println(this);
        File file = File.createTempFile("scanned", ".jarEntry");
        FileOutputStream out = new FileOutputStream(file);
        InputStream stream = this.stream();
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = stream.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
        stream.close();
        out.close();
        out.flush();
        return file;
    }

    public String toString() {
        return "jar-entry:" + this.path();
    }
}

