/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.scheduler;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.Calendar;

public class CronText {
    public static final int DAILY_FREQUENCY = 4;
    public static final int HOURLY_FREQUENCY = 3;
    public static final int MINUTELY_FREQUENCY = 2;
    public static final int MONTHLY_FREQUENCY = 6;
    public static final int NO_FREQUENCY = 0;
    public static final int SECONDLY_FREQUENCY = 1;
    public static final int WEEKLY_FREQUENCY = 5;
    public static final int YEARLY_FREQUENCY = 7;
    private int _frequency;
    private int _interval;
    private Calendar _startDate;

    public CronText(Calendar startDate) {
        this(startDate, 0, 0);
    }

    public CronText(Calendar startDate, int frequency, int interval) {
        this._startDate = startDate;
        this.setFrequency(frequency);
        this._interval = interval;
    }

    public int getFrequency() {
        return this._frequency;
    }

    public int getInterval() {
        return this._interval;
    }

    public Calendar getStartDate() {
        return this._startDate;
    }

    public void setFrequency(int frequency) {
        if (frequency != 4 && frequency != 3 && frequency != 2 && frequency != 6 && frequency != 0 && frequency != 1 && frequency != 5 && frequency != 7) {
            throw new IllegalArgumentException(String.valueOf(frequency));
        }
        this._frequency = frequency;
    }

    public void setInterval(int interval) {
        this._interval = interval;
    }

    public void setStartDate(Calendar startDate) {
        this._startDate = startDate;
    }

    public String toString() {
        String second = String.valueOf(this._startDate.get(13));
        String minute = String.valueOf(this._startDate.get(12));
        String hour = String.valueOf(this._startDate.get(11));
        String dayOfMonth = String.valueOf(this._startDate.get(5));
        String month = String.valueOf(this._startDate.get(2) + 1);
        String dayOfWeek = String.valueOf(this._startDate.get(7));
        String year = String.valueOf(this._startDate.get(1));
        if (this._frequency == 0) {
            dayOfWeek = "?";
        } else if (this._frequency == 1) {
            second = "*/" + this._interval;
            minute = "*";
            hour = "*";
            dayOfMonth = "*";
            month = "*";
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 2) {
            minute = "*/" + this._interval;
            hour = "*";
            dayOfMonth = "*";
            month = "*";
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 3) {
            minute = "*";
            hour = "*/" + this._interval;
            dayOfMonth = "*";
            month = "*";
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 4) {
            dayOfMonth = String.valueOf(dayOfMonth) + "/" + this._interval;
            month = "*";
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 5) {
            dayOfMonth = String.valueOf(dayOfMonth) + "/" + this._interval * 7;
            month = "*";
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 6) {
            month = String.valueOf(month) + "/" + this._interval;
            dayOfWeek = "?";
            year = "*";
        } else if (this._frequency == 7) {
            dayOfWeek = "?";
            year = String.valueOf(year) + "/" + this._interval;
        }
        StringBundler sb = new StringBundler(13);
        sb.append(second);
        sb.append(" ");
        sb.append(minute);
        sb.append(" ");
        sb.append(hour);
        sb.append(" ");
        sb.append(dayOfMonth);
        sb.append(" ");
        sb.append(month);
        sb.append(" ");
        sb.append(dayOfWeek);
        sb.append(" ");
        sb.append(year);
        return sb.toString();
    }
}

