/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import org.apache.commons.lang.StringUtils;
import org.jamwiki.utils.WikiLogger;

public class WikiVersion {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiVersion.class.getName());
    private final int major;
    private final int minor;
    private final int patch;
    public static final String CURRENT_WIKI_VERSION = "1.0.7";

    public WikiVersion(String version) {
        if (StringUtils.isBlank((String)version)) {
            throw new IllegalArgumentException("Invalid Wiki version: " + version);
        }
        String[] tokens = version.split("\\.");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Invalid Wiki version: " + version);
        }
        this.major = Integer.valueOf(tokens[0]);
        this.minor = Integer.valueOf(tokens[1]);
        this.patch = Integer.valueOf(tokens[2]);
    }

    public boolean before(WikiVersion version) {
        return this.before(version.major, version.minor, version.patch);
    }

    public boolean before(int major, int minor, int patch) {
        if (this.major < major) {
            return true;
        }
        if (this.major == major && this.minor < minor) {
            return true;
        }
        return this.major == major && this.minor == minor && this.patch < patch;
    }
}

