/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.jamwiki.Environment;
import org.jamwiki.db.AnsiQueryHandler;
import org.jamwiki.model.TopicType;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.SortedProperties;
import org.jamwiki.utils.WikiLogger;

public class DB2400QueryHandler
extends AnsiQueryHandler {
    private static final WikiLogger logger = WikiLogger.getLogger(DB2400QueryHandler.class.getName());
    private static final String SQL_PROPERTY_FILE_NAME = "sql.db2400.properties";

    protected DB2400QueryHandler() {
        SortedProperties defaults = Environment.loadProperties("sql.ansi.properties");
        SortedProperties props = Environment.loadProperties(SQL_PROPERTY_FILE_NAME, defaults);
        super.init(props);
    }

    private static String formatStatement(String sql, Pagination pagination) {
        try {
            Object[] objects = new Object[]{pagination.getEnd(), pagination.getNumResults()};
            return MessageFormat.format(sql, objects);
        }
        catch (Exception e) {
            logger.warn("Unable to format " + sql + " with values " + pagination.getEnd() + " / " + pagination.getNumResults(), e);
            return null;
        }
    }

    protected PreparedStatement getCategoriesStatement(Connection conn, int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_CATEGORIES, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, virtualWikiId);
        return stmt;
    }

    protected PreparedStatement getLogItemsStatement(Connection conn, int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        int index = 1;
        PreparedStatement stmt = null;
        String sql = null;
        if (logType == -1) {
            sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_LOG_ITEMS, pagination);
            stmt = conn.prepareStatement(sql);
        } else {
            sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_LOG_ITEMS_BY_TYPE, pagination);
            stmt = conn.prepareStatement(sql);
            stmt.setInt(index++, logType);
        }
        stmt.setInt(index++, virtualWikiId);
        return stmt;
    }

    protected PreparedStatement getRecentChangesStatement(Connection conn, String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_RECENT_CHANGES, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, virtualWiki);
        return stmt;
    }

    protected PreparedStatement getTopicHistoryStatement(Connection conn, int topicId, Pagination pagination, boolean descending) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_TOPIC_HISTORY, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, topicId);
        return stmt;
    }

    protected PreparedStatement getTopicsAdminStatement(Connection conn, int virtualWikiId, Pagination pagination) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_TOPICS_ADMIN, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, virtualWikiId);
        return stmt;
    }

    protected PreparedStatement getUserContributionsByLoginStatement(Connection conn, String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, login);
        return stmt;
    }

    protected PreparedStatement getUserContributionsByUserDisplayStatement(Connection conn, String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, userDisplay);
        return stmt;
    }

    protected PreparedStatement getWatchlistStatement(Connection conn, int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_WATCHLIST_CHANGES, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, userId);
        return stmt;
    }

    protected PreparedStatement lookupTopicByTypeStatement(Connection conn, int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_TOPIC_BY_TYPE, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, topicType1.id());
        stmt.setInt(3, topicType2.id());
        stmt.setInt(4, namespaceStart);
        stmt.setInt(5, namespaceEnd);
        return stmt;
    }

    protected PreparedStatement lookupWikiUsersStatement(Connection conn, Pagination pagination) throws SQLException {
        String sql = DB2400QueryHandler.formatStatement(STATEMENT_SELECT_WIKI_USERS, pagination);
        PreparedStatement stmt = conn.prepareStatement(sql);
        return stmt;
    }
}

