/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.db.AnsiQueryHandler;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.TopicType;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.SortedProperties;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleQueryHandler
extends AnsiQueryHandler {
    private static final WikiLogger logger = WikiLogger.getLogger(OracleQueryHandler.class.getName());
    private static final String SQL_PROPERTY_FILE_NAME = "sql.oracle.properties";

    protected OracleQueryHandler() {
        SortedProperties defaults = Environment.loadProperties("sql.ansi.properties");
        SortedProperties props = Environment.loadProperties(SQL_PROPERTY_FILE_NAME, defaults);
        super.init(props);
    }

    @Override
    protected PreparedStatement getCategoriesStatement(Connection conn, int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_CATEGORIES);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, pagination.getEnd());
        stmt.setInt(3, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getLogItemsStatement(Connection conn, int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        int index = 1;
        PreparedStatement stmt = null;
        if (logType == -1) {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS);
        } else {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS_BY_TYPE);
            stmt.setInt(index++, logType);
        }
        stmt.setInt(index++, virtualWikiId);
        stmt.setInt(index++, pagination.getEnd());
        stmt.setInt(index++, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getRecentChangesStatement(Connection conn, String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_RECENT_CHANGES);
        stmt.setString(1, virtualWiki);
        stmt.setInt(2, pagination.getEnd());
        stmt.setInt(3, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getTopicHistoryStatement(Connection conn, int topicId, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_HISTORY);
        stmt.setInt(1, topicId);
        stmt.setInt(2, pagination.getEnd());
        stmt.setInt(3, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getTopicsAdminStatement(Connection conn, int virtualWikiId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPICS_ADMIN);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, pagination.getEnd());
        stmt.setInt(3, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getUserContributionsByLoginStatement(Connection conn, String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, login);
        stmt.setInt(3, pagination.getEnd());
        stmt.setInt(4, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement getUserContributionsByUserDisplayStatement(Connection conn, String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, userDisplay);
        stmt.setInt(3, pagination.getEnd());
        stmt.setInt(4, pagination.getStart());
        return stmt;
    }

    @Override
    public List<Namespace> lookupNamespaces(Connection conn) throws SQLException {
        List<Namespace> namespaces = super.lookupNamespaces(conn);
        for (Namespace namespace : namespaces) {
            if (!StringUtils.isBlank((String)namespace.getDefaultLabel())) continue;
            namespace.setDefaultLabel("");
        }
        return namespaces;
    }

    @Override
    protected PreparedStatement getWatchlistStatement(Connection conn, int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WATCHLIST_CHANGES);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, userId);
        stmt.setInt(3, pagination.getEnd());
        stmt.setInt(4, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement lookupTopicByTypeStatement(Connection conn, int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_BY_TYPE);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, topicType1.id());
        stmt.setInt(3, topicType2.id());
        stmt.setInt(4, namespaceStart);
        stmt.setInt(5, namespaceEnd);
        stmt.setInt(6, pagination.getEnd());
        stmt.setInt(7, pagination.getStart());
        return stmt;
    }

    @Override
    protected PreparedStatement lookupWikiUsersStatement(Connection conn, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USERS);
        stmt.setInt(1, pagination.getEnd());
        stmt.setInt(2, pagination.getStart());
        return stmt;
    }

    @Override
    public void updateNamespace(Namespace mainNamespace, Namespace commentsNamespace, Connection conn) throws SQLException {
        if (StringUtils.isBlank((String)mainNamespace.getDefaultLabel())) {
            mainNamespace.setDefaultLabel(" ");
        }
        if (commentsNamespace != null && StringUtils.isBlank((String)commentsNamespace.getDefaultLabel())) {
            commentsNamespace.setDefaultLabel(" ");
        }
        super.updateNamespace(mainNamespace, commentsNamespace, conn);
        if (StringUtils.isBlank((String)mainNamespace.getDefaultLabel())) {
            mainNamespace.setDefaultLabel("");
        }
        if (commentsNamespace != null && StringUtils.isBlank((String)commentsNamespace.getDefaultLabel())) {
            commentsNamespace.setDefaultLabel("");
        }
    }

    @Override
    public void updateNamespaceTranslations(List<Namespace> namespaces, String virtualWiki, int virtualWikiId, Connection conn) throws SQLException {
        for (Namespace namespace : namespaces) {
            if (!StringUtils.isBlank((String)namespace.getDefaultLabel())) continue;
            namespace.setDefaultLabel(" ");
        }
        super.updateNamespaceTranslations(namespaces, virtualWiki, virtualWikiId, conn);
        for (Namespace namespace : namespaces) {
            if (!StringUtils.isBlank((String)namespace.getDefaultLabel())) continue;
            namespace.setDefaultLabel("");
        }
    }
}

