/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiBase;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespace
implements Serializable {
    public static final String SEPARATOR = ":";
    public static final int MEDIA_ID = -2;
    public static final int SPECIAL_ID = -1;
    public static final int MAIN_ID = 0;
    public static final int COMMENTS_ID = 1;
    public static final int USER_ID = 2;
    public static final int USER_COMMENTS_ID = 3;
    public static final int SITE_CUSTOM_ID = 4;
    public static final int SITE_CUSTOM_COMMENTS_ID = 5;
    public static final int FILE_ID = 6;
    public static final int FILE_COMMENTS_ID = 7;
    public static final int JAMWIKI_ID = 8;
    public static final int JAMWIKI_COMMENTS_ID = 9;
    public static final int TEMPLATE_ID = 10;
    public static final int TEMPLATE_COMMENTS_ID = 11;
    public static final int HELP_ID = 12;
    public static final int HELP_COMMENTS_ID = 13;
    public static final int CATEGORY_ID = 14;
    public static final int CATEGORY_COMMENTS_ID = 15;
    private static final Namespace MEDIA = new Namespace(-2, "Media", null);
    private static final Namespace SPECIAL = new Namespace(-1, "Special", null);
    private static final Namespace MAIN = new Namespace(0, "", null);
    private static final Namespace COMMENTS = new Namespace(1, "Comments", MAIN);
    private static final Namespace USER = new Namespace(2, "User", null);
    private static final Namespace USER_COMMENTS = new Namespace(3, "User comments", USER);
    private static final Namespace SITE_CUSTOM = new Namespace(4, "Project", null);
    private static final Namespace SITE_CUSTOM_COMMENTS = new Namespace(5, "Project comments", SITE_CUSTOM);
    private static final Namespace FILE = new Namespace(6, "Image", null);
    private static final Namespace FILE_COMMENTS = new Namespace(7, "Image comments", FILE);
    private static final Namespace JAMWIKI = new Namespace(8, "JAMWiki", null);
    private static final Namespace JAMWIKI_COMMENTS = new Namespace(9, "JAMWiki comments", JAMWIKI);
    private static final Namespace TEMPLATE = new Namespace(10, "Template", null);
    private static final Namespace TEMPLATE_COMMENTS = new Namespace(11, "Template comments", TEMPLATE);
    private static final Namespace HELP = new Namespace(12, "Help", null);
    private static final Namespace HELP_COMMENTS = new Namespace(13, "Help comments", HELP);
    private static final Namespace CATEGORY = new Namespace(14, "Category", null);
    private static final Namespace CATEGORY_COMMENTS = new Namespace(15, "Category comments", CATEGORY);
    public static Map<Integer, Namespace> DEFAULT_NAMESPACES = new LinkedHashMap<Integer, Namespace>();
    private Integer id;
    private String label;
    private Namespace mainNamespace;
    private Map<String, String> namespaceTranslations = new HashMap<String, String>();
    private static final WikiLogger logger;

    public Namespace(Integer id, String label) {
        this.id = id;
        this.label = label;
    }

    private Namespace(Integer id, String label, Namespace mainNamespace) {
        this.id = id;
        this.label = label;
        this.mainNamespace = mainNamespace;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDefaultLabel() {
        return this.label;
    }

    public void setDefaultLabel(String label) {
        this.label = label;
    }

    public String getLabel(String virtualWiki) {
        return virtualWiki != null && this.namespaceTranslations.get(virtualWiki) != null ? this.namespaceTranslations.get(virtualWiki) : this.label;
    }

    public Namespace getMainNamespace() {
        return this.mainNamespace;
    }

    public void setMainNamespace(Namespace mainNamespace) {
        this.mainNamespace = mainNamespace;
    }

    public Map<String, String> getNamespaceTranslations() {
        return this.namespaceTranslations;
    }

    public boolean isCaseSensitive() {
        if (this.getId().equals(-1)) {
            return false;
        }
        if (this.getId().equals(10) || this.getId().equals(11)) {
            return false;
        }
        if (this.getId().equals(2) || this.getId().equals(3)) {
            return false;
        }
        return !this.getId().equals(14) && !this.getId().equals(15);
    }

    public static Namespace findCommentsNamespace(Namespace namespace) throws DataAccessException {
        if (namespace == null) {
            return null;
        }
        if (namespace.mainNamespace != null) {
            return namespace;
        }
        List<Namespace> namespaces = WikiBase.getDataHandler().lookupNamespaces();
        for (Namespace candidateNamespace : namespaces) {
            if (candidateNamespace.mainNamespace == null || !candidateNamespace.mainNamespace.equals(namespace)) continue;
            return candidateNamespace;
        }
        return null;
    }

    public static Namespace findMainNamespace(Namespace namespace) {
        if (namespace == null) {
            return null;
        }
        return namespace.mainNamespace == null ? namespace : namespace.mainNamespace;
    }

    public static Namespace namespace(int namespaceId) {
        try {
            return WikiBase.getDataHandler().lookupNamespaceById(namespaceId);
        }
        catch (DataAccessException e) {
            logger.error("Failure while retrieving namespace for ID: " + namespaceId, e);
            return null;
        }
    }

    public boolean equals(Namespace namespace) {
        return namespace != null && this.label.equals(namespace.getDefaultLabel());
    }

    static {
        DEFAULT_NAMESPACES.put(MEDIA.getId(), MEDIA);
        DEFAULT_NAMESPACES.put(SPECIAL.getId(), SPECIAL);
        DEFAULT_NAMESPACES.put(MAIN.getId(), MAIN);
        DEFAULT_NAMESPACES.put(COMMENTS.getId(), COMMENTS);
        DEFAULT_NAMESPACES.put(USER.getId(), USER);
        DEFAULT_NAMESPACES.put(USER_COMMENTS.getId(), USER_COMMENTS);
        DEFAULT_NAMESPACES.put(SITE_CUSTOM.getId(), SITE_CUSTOM);
        DEFAULT_NAMESPACES.put(SITE_CUSTOM_COMMENTS.getId(), SITE_CUSTOM_COMMENTS);
        DEFAULT_NAMESPACES.put(FILE.getId(), FILE);
        DEFAULT_NAMESPACES.put(FILE_COMMENTS.getId(), FILE_COMMENTS);
        DEFAULT_NAMESPACES.put(JAMWIKI.getId(), JAMWIKI);
        DEFAULT_NAMESPACES.put(JAMWIKI_COMMENTS.getId(), JAMWIKI_COMMENTS);
        DEFAULT_NAMESPACES.put(TEMPLATE.getId(), TEMPLATE);
        DEFAULT_NAMESPACES.put(TEMPLATE_COMMENTS.getId(), TEMPLATE_COMMENTS);
        DEFAULT_NAMESPACES.put(HELP.getId(), HELP);
        DEFAULT_NAMESPACES.put(HELP_COMMENTS.getId(), HELP_COMMENTS);
        DEFAULT_NAMESPACES.put(CATEGORY.getId(), CATEGORY);
        DEFAULT_NAMESPACES.put(CATEGORY_COMMENTS.getId(), CATEGORY_COMMENTS);
        logger = WikiLogger.getLogger(Namespace.class.getName());
    }
}

