/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.WikiMessage;
import org.jamwiki.model.LogItem;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentChange {
    private static final WikiLogger logger = WikiLogger.getLogger(RecentChange.class.getName());
    private Integer authorId = null;
    private String authorName = null;
    private Integer charactersChanged = null;
    private String changeComment = null;
    private Timestamp changeDate = null;
    private transient WikiMessage changeWikiMessage = null;
    private Integer editType = null;
    private Integer logType = null;
    private List<String> params = null;
    private Integer previousTopicVersionId = null;
    private Integer topicId = null;
    private String topicName = null;
    private Integer topicVersionId = null;
    private String virtualWiki = null;

    public static RecentChange initRecentChange(Topic topic, TopicVersion topicVersion, String authorName) {
        RecentChange recentChange = new RecentChange();
        recentChange.setTopicId(topic.getTopicId());
        recentChange.setTopicName(topic.getName());
        recentChange.setTopicVersionId(topicVersion.getTopicVersionId());
        recentChange.setPreviousTopicVersionId(topicVersion.getPreviousTopicVersionId());
        recentChange.setAuthorId(topicVersion.getAuthorId());
        recentChange.setAuthorName(authorName);
        recentChange.setCharactersChanged(topicVersion.getCharactersChanged());
        recentChange.setChangeComment(topicVersion.getEditComment());
        recentChange.setChangeDate(topicVersion.getEditDate());
        recentChange.setEditType(topicVersion.getEditType());
        recentChange.setVirtualWiki(topic.getVirtualWiki());
        recentChange.setParamString(topicVersion.getVersionParamString());
        recentChange.initChangeWikiMessageForVersion(topicVersion.getEditType(), topicVersion.getVersionParamString());
        return recentChange;
    }

    public static RecentChange initRecentChange(LogItem logItem) {
        RecentChange recentChange = new RecentChange();
        recentChange.setAuthorId(logItem.getUserId());
        recentChange.setAuthorName(logItem.getUserDisplayName());
        recentChange.setChangeComment(logItem.getLogComment());
        recentChange.setChangeDate(logItem.getLogDate());
        recentChange.setVirtualWiki(logItem.getVirtualWiki());
        recentChange.setParamString(logItem.getLogParamString());
        recentChange.setLogType(logItem.getLogType());
        recentChange.initChangeWikiMessageForLog(logItem.getLogType(), logItem.getLogParamString());
        return recentChange;
    }

    public void initChangeWikiMessageForLog(int logType, String logParamString) {
        this.setChangeWikiMessage(LogItem.retrieveLogWikiMessage(logType, logParamString));
    }

    public void initChangeWikiMessageForVersion(int editType, String versionParamString) {
        if (StringUtils.isBlank((String)versionParamString)) {
            return;
        }
        if (editType == 4) {
            this.setChangeWikiMessage(new WikiMessage("move.editcomment", versionParamString.split("\\|")));
        } else if (editType == 6) {
            this.setChangeWikiMessage(new WikiMessage("manage.message.permissions"));
        }
    }

    public Integer getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getChangeComment() {
        return this.changeComment;
    }

    public void setChangeComment(String changeComment) {
        this.changeComment = changeComment;
    }

    public Timestamp getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Timestamp changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeTypeNotification() {
        StringBuilder changeTypeNotification = new StringBuilder();
        if (this.previousTopicVersionId == null) {
            changeTypeNotification.append('n');
        }
        if (this.editType == null) {
            return "";
        }
        if (this.editType == 2) {
            changeTypeNotification.append('m');
        }
        if (this.editType == 5) {
            changeTypeNotification.append('d');
        }
        if (this.editType == 7) {
            changeTypeNotification.append('u');
        }
        if (this.editType == 8) {
            changeTypeNotification.append('i');
        }
        return changeTypeNotification.toString();
    }

    public WikiMessage getChangeWikiMessage() {
        return this.changeWikiMessage;
    }

    public void setChangeWikiMessage(WikiMessage changeWikiMessage) {
        this.changeWikiMessage = changeWikiMessage;
    }

    public Integer getCharactersChanged() {
        return this.charactersChanged;
    }

    public void setCharactersChanged(Integer charactersChanged) {
        this.charactersChanged = charactersChanged;
    }

    public Integer getEditType() {
        return this.editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getLogType() {
        return this.logType;
    }

    public void setLogType(Integer logType) {
        this.logType = logType;
    }

    public String getLogWikiLinkCaption() {
        return LogItem.LOG_TYPES.get(this.logType);
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public String getParamString() {
        return Utilities.listToDelimitedString(this.params, "|");
    }

    public void setParamString(String paramsString) {
        this.setParams(Utilities.delimitedStringToList(paramsString, "|"));
    }

    public Integer getPreviousTopicVersionId() {
        return this.previousTopicVersionId;
    }

    public void setPreviousTopicVersionId(Integer previousTopicVersionId) {
        this.previousTopicVersionId = previousTopicVersionId;
    }

    public Integer getTopicId() {
        return this.topicId;
    }

    public void setTopicId(Integer topicId) {
        this.topicId = topicId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public Integer getTopicVersionId() {
        return this.topicVersionId;
    }

    public void setTopicVersionId(Integer topicVersionId) {
        this.topicVersionId = topicVersionId;
    }

    public String getVirtualWiki() {
        return this.virtualWiki;
    }

    public void setVirtualWiki(String virtualWiki) {
        this.virtualWiki = virtualWiki;
    }

    public boolean isDelete() {
        if (this.editType != null && this.editType == 5) {
            return true;
        }
        return this.logType != null && this.logType == 1;
    }

    public boolean isImportChange() {
        if (this.editType != null && this.editType == 8) {
            return true;
        }
        return this.logType != null && this.logType == 2;
    }

    public boolean getMinor() {
        return this.editType != null && this.editType == 2;
    }

    public boolean isMove() {
        if (this.editType != null && this.editType == 4) {
            return true;
        }
        return this.logType != null && this.logType == 3;
    }

    public boolean isPermission() {
        return this.logType != null && this.logType == 4;
    }

    public boolean isNormal() {
        return this.editType != null && this.editType == 1;
    }

    public boolean isUndelete() {
        return this.editType != null && this.editType == 7;
    }

    public boolean isUpload() {
        return this.logType != null && this.logType == 6;
    }

    public boolean isUser() {
        return this.logType != null && this.logType == 7;
    }
}

