/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.TopicType;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class Topic
implements Serializable {
    private boolean adminOnly = false;
    private Integer currentVersionId = null;
    private Timestamp deleteDate = null;
    private Namespace namespace = Namespace.namespace(0);
    private String pageName = null;
    private boolean readOnly = false;
    private String redirectTo = null;
    private String topicContent = null;
    private int topicId = -1;
    private TopicType topicType = TopicType.ARTICLE;
    private String virtualWiki = null;
    private static final WikiLogger logger = WikiLogger.getLogger(Topic.class.getName());

    public Topic(String virtualWiki, String name) {
        this.virtualWiki = virtualWiki;
        this.setName(name);
    }

    public Topic(String virtualWiki, Namespace namespace, String pageName) {
        this.virtualWiki = virtualWiki;
        this.namespace = namespace;
        this.pageName = pageName;
    }

    public Topic(Topic topic) {
        this.adminOnly = topic.adminOnly;
        this.currentVersionId = topic.currentVersionId;
        this.deleteDate = topic.deleteDate;
        this.namespace = topic.namespace;
        this.pageName = topic.pageName;
        this.readOnly = topic.readOnly;
        this.redirectTo = topic.redirectTo;
        this.topicContent = topic.topicContent;
        this.topicId = topic.topicId;
        this.topicType = topic.topicType;
        this.virtualWiki = topic.virtualWiki;
    }

    public boolean getAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public Integer getCurrentVersionId() {
        return this.currentVersionId;
    }

    public void setCurrentVersionId(Integer currentVersionId) {
        this.currentVersionId = currentVersionId;
    }

    public boolean getDeleted() {
        return this.deleteDate != null;
    }

    public Timestamp getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Timestamp deleteDate) {
        this.deleteDate = deleteDate;
    }

    public String getName() {
        String name = this.pageName;
        if (!StringUtils.isBlank((String)this.namespace.getLabel(this.virtualWiki))) {
            name = this.namespace.getLabel(this.virtualWiki) + ":" + this.pageName;
        }
        return name;
    }

    public void setName(String name) {
        WikiLink wikiLink = LinkUtil.parseWikiLink(this.virtualWiki, name);
        this.namespace = wikiLink.getNamespace();
        this.pageName = wikiLink.getArticle();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public void setRedirectTo(String redirectTo) {
        this.redirectTo = redirectTo;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTopicContent() {
        return this.topicContent;
    }

    public void setTopicContent(String topicContent) {
        this.topicContent = topicContent;
    }

    public int getTopicId() {
        return this.topicId;
    }

    public void setTopicId(int topicId) {
        this.topicId = topicId;
    }

    public TopicType getTopicType() {
        return this.topicType;
    }

    public void setTopicType(TopicType topicType) {
        this.topicType = topicType;
    }

    public String getVirtualWiki() {
        return this.virtualWiki;
    }

    public static String buildTopicName(String virtualWiki, Namespace namespace, String pageName) {
        String topicName = namespace.getLabel(virtualWiki);
        if (topicName.length() != 0) {
            topicName = topicName + ":";
        }
        topicName = topicName + pageName;
        return topicName;
    }
}

