/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.model.WikiReference;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.HtmlTagItem;
import org.jamwiki.parser.jflex.JAMWikiHtmlProcessor;
import org.jamwiki.parser.jflex.JFlexParser;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlexParserUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(JFlexParserUtil.class.getName());

    private JFlexParserUtil() {
    }

    public static String parseFragment(ParserInput parserInput, ParserOutput parserOutput, String raw, int mode) throws ParserException {
        if (StringUtils.isBlank((String)raw)) {
            return raw;
        }
        JFlexParser parser = new JFlexParser(parserInput);
        return parser.parseFragment(parserOutput, raw, mode);
    }

    protected static WikiLink parseWikiLink(ParserInput parserInput, ParserOutput parserOutput, String raw) throws ParserException {
        if (StringUtils.isBlank((String)raw)) {
            return new WikiLink();
        }
        String suffix = !(raw = raw.trim()).endsWith("]]") ? raw.substring(raw.lastIndexOf("]]") + 2) : null;
        raw = raw.substring(raw.indexOf("[[") + 2, raw.lastIndexOf("]]")).trim();
        raw = JFlexParserUtil.parseFragment(parserInput, parserOutput, raw, 5);
        boolean colon = false;
        if (raw.startsWith(":")) {
            colon = true;
            raw = raw.substring(1).trim();
        }
        String text = null;
        int pos = raw.indexOf(124);
        if (pos != -1 && pos != raw.length() - 1) {
            text = raw.substring(pos + 1).trim();
            raw = raw.substring(0, pos).trim();
        }
        String virtualWiki = parserInput.getVirtualWiki();
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, raw);
        if (!colon && wikiLink.getNamespace().getId().equals(14)) {
            wikiLink.setText(null);
        }
        if (wikiLink.getVirtualWiki() != null && !StringUtils.equals((String)wikiLink.getVirtualWiki().getName(), (String)virtualWiki) && StringUtils.isBlank((String)wikiLink.getDestination())) {
            wikiLink.setDestination(wikiLink.getVirtualWiki().getRootTopicName());
            if (StringUtils.isBlank((String)wikiLink.getText())) {
                wikiLink.setText(wikiLink.getVirtualWiki().getName() + ":");
            }
        }
        if (wikiLink.getInterwiki() != null && StringUtils.isBlank((String)wikiLink.getDestination()) && StringUtils.isBlank((String)wikiLink.getText())) {
            wikiLink.setText(wikiLink.getInterwiki().getInterwikiPrefix() + ":");
        }
        wikiLink.setColon(colon);
        if (text != null) {
            wikiLink.setText(text);
        }
        if (!StringUtils.isBlank((String)suffix)) {
            wikiLink.setText(wikiLink.getText() + suffix);
        }
        return wikiLink;
    }

    protected static String tagContent(String raw) {
        int start = raw.indexOf(62) + 1;
        int end = raw.lastIndexOf(60);
        if (start == 0) {
            return raw;
        }
        if (end <= start) {
            return "";
        }
        return raw.substring(start, end);
    }

    protected static List<WikiReference> retrieveReferences(ParserInput parserInput) {
        ArrayList references = (ArrayList)parserInput.getTempParams().get("WikiReferenceTag.REFERENCES_PARAM");
        if (references == null) {
            references = new ArrayList();
            parserInput.getTempParams().put("WikiReferenceTag.REFERENCES_PARAM", references);
        }
        return references;
    }

    public static HtmlTagItem sanitizeHtmlTag(String tag) throws ParserException {
        if (StringUtils.isBlank((String)tag)) {
            return null;
        }
        tag = tag.replace('\n', ' ');
        JAMWikiHtmlProcessor lexer = new JAMWikiHtmlProcessor(new StringReader(tag));
        StringBuilder result = new StringBuilder();
        try {
            String line;
            while ((line = lexer.yylex()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            throw new ParserException("Failure while parsing: " + tag, e);
        }
        return new HtmlTagItem(lexer.getTagType(), result.toString());
    }

    protected static List<String> tokenizeParamString(String content) {
        ArrayList<String> tokens = new ArrayList<String>();
        int pos = 0;
        int endPos = -1;
        String substring = "";
        String value = "";
        while (pos < content.length()) {
            substring = content.substring(pos);
            endPos = -1;
            if (substring.startsWith("{{{")) {
                endPos = Utilities.findMatchingEndTag(content, pos, "{{{", "}}}");
            } else if (substring.startsWith("{{")) {
                endPos = Utilities.findMatchingEndTag(content, pos, "{{", "}}");
            } else if (substring.startsWith("[[")) {
                endPos = Utilities.findMatchingEndTag(content, pos, "[[", "]]");
            } else if (substring.startsWith("{|")) {
                endPos = Utilities.findMatchingEndTag(content, pos, "{|", "|}");
            } else if (content.charAt(pos) == '|') {
                tokens.add(value);
                value = "";
                ++pos;
                continue;
            }
            if (endPos != -1) {
                value = value + content.substring(pos, endPos);
                pos = endPos;
                continue;
            }
            value = value + content.charAt(pos);
            ++pos;
        }
        tokens.add(value);
        return tokens;
    }
}

