/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.parser.jflex.JFlexTagItem;
import org.jamwiki.utils.WikiLogger;

public class JavascriptTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(JavascriptTag.class.getName());

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (logger.isTraceEnabled()) {
            logger.trace("javascript: " + raw + " (" + lexer.yystate() + ")");
        }
        if (StringUtils.isBlank((String)raw)) {
            return raw;
        }
        return this.parseScriptTag(lexer.getParserInput(), lexer.getParserOutput(), raw, lexer.getMode());
    }

    private String parsePostProcess(ParserInput parserInput, String raw) {
        if (Environment.getBooleanValue("allow-javascript")) {
            return raw;
        }
        logger.warn("Potential XSS attack detected from user " + parserInput.getUserDisplay() + ": " + raw);
        return StringEscapeUtils.escapeHtml((String)raw);
    }

    private String parseScriptTag(ParserInput parserInput, ParserOutput parserOutput, String raw, int mode) throws ParserException {
        if (mode >= 9) {
            return this.parsePostProcess(parserInput, raw);
        }
        int pos = raw.indexOf(62);
        String openTag = raw.substring(0, pos + 1);
        raw = raw.substring(pos + 1);
        pos = raw.lastIndexOf(60);
        String closeTag = raw.substring(pos);
        raw = raw.substring(0, pos);
        if (!Environment.getBooleanValue("allow-javascript")) {
            return StringEscapeUtils.escapeHtml((String)openTag) + JFlexParserUtil.parseFragment(parserInput, parserOutput, raw, mode) + StringEscapeUtils.escapeHtml((String)closeTag);
        }
        JFlexTagItem tag = new JFlexTagItem("script", openTag);
        tag.getTagContent().append(raw);
        return tag.toHtml();
    }
}

