/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.model.WikiReference;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.WikiLogger;

public class WikiReferencesTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiReferencesTag.class.getName());

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (logger.isTraceEnabled()) {
            logger.trace("references: " + raw + " (" + lexer.yystate() + ")");
        }
        if (lexer.getMode() < 9) {
            return raw;
        }
        List<WikiReference> references = JFlexParserUtil.retrieveReferences(lexer.getParserInput());
        if (references.isEmpty()) {
            return "";
        }
        StringBuffer html = new StringBuffer("<ol class=\"references\">");
        while (!references.isEmpty()) {
            WikiReference reference = references.get(0);
            references.remove(0);
            html.append("\n<li id=\"").append(reference.getNotationName()).append("\">");
            html.append("<sup>");
            int pos = 0;
            ArrayList<WikiReference> citations = new ArrayList<WikiReference>();
            while (pos < references.size()) {
                WikiReference temp = references.get(pos);
                if (temp.getName() != null && reference.getName() != null && reference.getName().equals(temp.getName())) {
                    citations.add(temp);
                    if (StringUtils.isBlank((String)reference.getContent()) && !StringUtils.isBlank((String)temp.getContent())) {
                        reference.setContent(temp.getContent());
                    }
                    references.remove(pos);
                    continue;
                }
                ++pos;
            }
            if (!citations.isEmpty()) {
                html.append("<a href=\"#").append(reference.getReferenceName()).append("\">");
                html.append(reference.getCitation()).append('.').append(reference.getCount()).append("</a>&#160;");
                while (!citations.isEmpty()) {
                    WikiReference citation = (WikiReference)citations.get(0);
                    html.append("&#160;<a href=\"#").append(citation.getReferenceName()).append("\">");
                    html.append(citation.getCitation()).append('.').append(citation.getCount()).append("</a>&#160;");
                    citations.remove(0);
                }
            } else {
                html.append("<a href=\"#").append(reference.getReferenceName()).append("\">");
                html.append(reference.getCitation()).append("</a>&#160;");
            }
            html.append("</sup>");
            html.append(JFlexParserUtil.parseFragment(lexer.getParserInput(), lexer.getParserOutput(), reference.getContent(), 7));
            html.append("</li>");
        }
        html.append("\n</ol>");
        return html.toString();
    }
}

