/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;

public class ImageProcessor {
    private static final WikiLogger logger = WikiLogger.getLogger(ImageProcessor.class.getName());

    private ImageProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage loadImage(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedImage image = ImageIO.read(fis);
            if (image == null) {
                throw new IOException("JDK is unable to process image file, possibly indicating file corruption: " + file.getAbsolutePath());
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static BufferedImage resizeImage(File imageFile, int targetWidth, int targetHeight) throws IOException {
        long start = System.currentTimeMillis();
        BufferedImage tmp = ImageProcessor.loadImage(imageFile);
        int type = tmp.getTransparency() == 1 ? 1 : 2;
        int width = tmp.getWidth();
        int height = tmp.getHeight();
        BufferedImage resized = tmp;
        do {
            if ((width /= 2) < targetWidth) {
                width = targetWidth;
            }
            if ((height /= 2) < targetHeight) {
                height = targetHeight;
            }
            tmp = new BufferedImage(width, height, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(resized, 0, 0, width, height, null);
            g2.dispose();
            resized = tmp;
        } while (width != targetWidth || height != targetHeight);
        if (logger.isDebugEnabled()) {
            long current = System.currentTimeMillis();
            String message = "Image resize time (" + (double)(current - start) / 1000.0 + " s), dimensions: " + targetWidth + "x" + targetHeight + " for file: " + imageFile.getAbsolutePath();
            logger.debug(message);
        }
        return resized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Dimension retrieveImageDimensions(File imageFile) throws IOException {
        if (!imageFile.exists()) {
            logger.info("No file found while determining image dimensions: " + imageFile.getAbsolutePath());
            return null;
        }
        ImageInputStream iis = null;
        Dimension dimensions = null;
        ImageReader reader = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(imageFile);
            iis = ImageIO.createImageInputStream(fis);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                reader = readers.next();
                reader.setInput(iis, true);
                dimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveImage(BufferedImage image, File file) throws IOException {
        String filename = file.getName();
        int pos = filename.lastIndexOf(46);
        if (pos == -1 || pos + 1 >= filename.length()) {
            throw new IOException("Unknown image file type " + filename);
        }
        String imageType = filename.substring(pos + 1);
        File imageFile = new File(file.getParent(), filename);
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openOutputStream((File)imageFile);
            boolean result = ImageIO.write((RenderedImage)image, imageType, fos);
            if (!result) {
                throw new IOException("No appropriate writer found when writing image: " + filename);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        File directory = WikiUtil.getTempDirectory();
        if (directory.exists()) {
            ImageIO.setCacheDirectory(directory);
        }
    }
}

