/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import jodd.bean.BeanUtil;
import jodd.madvoc.ScopeType;
import jodd.madvoc.injector.ScopeData;
import jodd.madvoc.injector.ScopeDataResolver;

public abstract class BaseScopeInjector {
    protected static final ScopeDataResolver scopeDataResolver = new ScopeDataResolver();
    protected final ScopeType scopeType;

    protected BaseScopeInjector(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    protected void setTargetProperty(Object target, String name, Object attrValue, boolean create) {
        if (create) {
            BeanUtil.setDeclaredPropertyForcedSilent(target, name, attrValue);
        } else {
            BeanUtil.setDeclaredPropertySilent(target, name, attrValue);
        }
    }

    protected Object getTargetProperty(Object target, ScopeData.Out out) {
        if (out.target == null) {
            return BeanUtil.getDeclaredProperty(target, out.name);
        }
        return BeanUtil.getDeclaredProperty(target, out.target);
    }

    protected String getMatchedPropertyName(ScopeData.In in, String attrName) {
        char c;
        if (!attrName.startsWith(in.name)) {
            return null;
        }
        int requiredLen = in.name.length();
        if (attrName.length() >= requiredLen + 1 && (c = attrName.charAt(requiredLen)) != '.' && c != '[') {
            return null;
        }
        if (in.target == null) {
            return attrName;
        }
        return in.target + attrName.substring(in.name.length());
    }

    public ScopeData.In[] lookupInData(Class actionClass) {
        return scopeDataResolver.lookupInData(actionClass, this.scopeType);
    }

    public ScopeData.Out[] lookupOutData(Class actionClass) {
        return scopeDataResolver.lookupOutData(actionClass, this.scopeType);
    }
}

