/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import jodd.introspector.ClassDescriptor;
import jodd.petite.InitMethodPoint;
import jodd.petite.PetiteException;
import jodd.petite.meta.PetiteInitMethod;

public class InitMethodResolver {
    public InitMethodPoint[] resolve(Object bean) {
        InitMethodPoint[] methods;
        Method[] allMethods;
        Class<?> type = bean.getClass();
        ArrayList<InitMethodPoint> list = new ArrayList<InitMethodPoint>();
        ClassDescriptor cd = new ClassDescriptor(type, false);
        for (Method method : allMethods = cd.getAllMethods(true)) {
            PetiteInitMethod petiteInitMethod = method.getAnnotation(PetiteInitMethod.class);
            if (petiteInitMethod == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PetiteException("Arguments are not allowed for Petite init method: " + type.getName() + '#' + method.getName());
            }
            int order = petiteInitMethod.order();
            list.add(new InitMethodPoint(method, order, petiteInitMethod.invoke()));
        }
        if (list.isEmpty()) {
            methods = InitMethodPoint.EMPTY;
        } else {
            Collections.sort(list);
            methods = list.toArray(new InitMethodPoint[list.size()]);
        }
        return methods;
    }
}

