/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import jodd.asm.MethodAdapter;
import jodd.asm4.Label;
import jodd.asm4.MethodVisitor;
import jodd.asm4.Type;
import jodd.proxetta.InvokeAspect;
import jodd.proxetta.InvokeInfo;
import jodd.proxetta.InvokeReplacer;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.WorkData;

public class InvokeReplacerMethodAdapter
extends MethodAdapter {
    protected final WorkData wd;
    protected final MethodInfo methodInfo;
    protected final InvokeAspect[] aspects;
    protected boolean firstSuperCtorInitCalled;
    protected InvokeReplacer newInvokeReplacer;

    public InvokeReplacerMethodAdapter(MethodVisitor mv, MethodInfo methodInfo, WorkData wd, InvokeAspect[] aspects) {
        super(mv);
        this.wd = wd;
        this.aspects = aspects;
        this.methodInfo = methodInfo;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        InvokeAspect aspect;
        if (this.newInvokeReplacer != null && opcode == 183) {
            String exOwner = owner;
            owner = this.newInvokeReplacer.getOwner();
            name = this.newInvokeReplacer.getMethodName();
            desc = InvokeReplacerMethodAdapter.changeReturnType(desc, 'L' + exOwner + ';');
            super.visitMethodInsn(184, owner, name, desc);
            this.newInvokeReplacer = null;
            return;
        }
        InvokeInfo invokeInfo = new InvokeInfo(owner, name, desc);
        if (this.methodInfo.getMethodName().equals("<init>") && !this.firstSuperCtorInitCalled && opcode == 183 && name.equals("<init>") && owner.equals(this.wd.nextSupername)) {
            this.firstSuperCtorInitCalled = true;
            owner = this.wd.superReference;
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 183 && owner.equals(this.wd.nextSupername) && !name.equals("<init>")) {
            throw new ProxettaException("Super call detected in class " + this.methodInfo.getClassname() + " method: " + this.methodInfo.getSignature() + "\nProxetta can't handle super calls due to VM limitations.");
        }
        InvokeReplacer ir = null;
        InvokeAspect[] arr$ = this.aspects;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (ir = (aspect = arr$[i$]).pointcut(invokeInfo)) == null; ++i$) {
        }
        if (ir == null) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        this.wd.proxyApplied = true;
        String exOwner = owner;
        owner = ir.getOwner();
        name = ir.getMethodName();
        switch (opcode) {
            case 185: {
                desc = InvokeReplacerMethodAdapter.prependArgument(desc, "Ljava/lang/Object;");
                break;
            }
            case 182: {
                desc = InvokeReplacerMethodAdapter.prependArgument(desc, "Ljava/lang/Object;");
                break;
            }
            case 184: {
                break;
            }
            default: {
                throw new ProxettaException("Unsupported opcode: " + opcode);
            }
        }
        if (ir.isPassOwnerName()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(exOwner);
        }
        if (ir.isPassMethodName()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(this.methodInfo.getMethodName());
        }
        if (ir.isPassMethodSignature()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/String;");
            super.visitLdcInsn(this.methodInfo.getSignature());
        }
        if (ir.isPassTargetClass()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/Class;");
            this.mv.visitLdcInsn(Type.getType('L' + this.wd.superReference + ';'));
        }
        if (ir.isPassThis()) {
            desc = InvokeReplacerMethodAdapter.appendArgument(desc, "Ljava/lang/Object;");
            this.mv.visitVarInsn(25, 0);
        }
        super.visitMethodInsn(184, owner, name, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (owner.equals(this.wd.superReference)) {
            owner = this.wd.thisReference;
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187) {
            InvokeInfo invokeInfo = new InvokeInfo(type, "<init>", "");
            for (InvokeAspect aspect : this.aspects) {
                InvokeReplacer ir = aspect.pointcut(invokeInfo);
                if (ir == null) continue;
                this.newInvokeReplacer = ir;
                return;
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitInsn(int opcode) {
        if (this.newInvokeReplacer != null && opcode == 89) {
            return;
        }
        super.visitInsn(opcode);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    protected static String appendArgument(String desc, String type) {
        int ndx = desc.indexOf(41);
        return desc.substring(0, ndx) + type + desc.substring(ndx);
    }

    protected static String prependArgument(String desc, String type) {
        int ndx = desc.indexOf(40);
        return desc.substring(0, ++ndx) + type + desc.substring(ndx);
    }

    protected static String changeReturnType(String desc, String type) {
        int ndx = desc.indexOf(41);
        return desc.substring(0, ndx + 1) + type;
    }
}

