/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileNameUtil;
import jodd.servlet.ServletUtil;
import jodd.servlet.filter.GzipResponseWrapper;
import jodd.typeconverter.Convert;
import jodd.typeconverter.TypeConversionException;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class GzipFilter
implements Filter {
    protected int threshold;
    protected String[] matches;
    protected String[] excludes;
    protected boolean wildcards;
    protected String requestParameterName;
    protected String[] extensions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.threshold == 0 || !ServletUtil.isGzipSupported(req) || !this.isGzipEligible(req)) {
            chain.doFilter(request, response);
            return;
        }
        GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(res);
        wrappedResponse.setCompressionThreshold(this.threshold);
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String uriExclude;
        try {
            this.wildcards = Convert.toBooleanValue(config.getInitParameter("wildcards"), false);
        }
        catch (TypeConversionException ignore) {
            this.wildcards = false;
        }
        try {
            this.threshold = Convert.toIntValue(config.getInitParameter("threshold"), 0);
        }
        catch (TypeConversionException ignore) {
            this.threshold = 0;
        }
        String uriMatch = config.getInitParameter("match");
        if (uriMatch != null && !uriMatch.equals("*")) {
            this.matches = StringUtil.splitc(uriMatch, ',');
            for (int i = 0; i < this.matches.length; ++i) {
                this.matches[i] = this.matches[i].trim();
            }
        }
        if ((uriExclude = config.getInitParameter("exclude")) != null) {
            this.excludes = StringUtil.splitc(uriExclude, ',');
            for (int i = 0; i < this.excludes.length; ++i) {
                this.excludes[i] = this.excludes[i].trim();
            }
        }
        this.requestParameterName = config.getInitParameter("requestParameterName");
        if (this.requestParameterName == null) {
            this.requestParameterName = "gzip";
        }
        this.requestParameterName = this.requestParameterName.trim();
        String urlExtensions = config.getInitParameter("extensions");
        this.extensions = urlExtensions != null ? StringUtil.splitc(urlExtensions, ", ") : new String[]{"html", "html", "js", "css"};
    }

    public void destroy() {
        this.matches = null;
        this.excludes = null;
    }

    protected boolean isGzipEligible(HttpServletRequest request) {
        boolean result;
        block8: {
            String uri;
            block9: {
                block7: {
                    block6: {
                        String forceGzipString;
                        if (this.requestParameterName.length() != 0 && (forceGzipString = request.getParameter(this.requestParameterName)) != null) {
                            return Convert.toBooleanValue(forceGzipString, false);
                        }
                        uri = request.getRequestURI();
                        if (uri == null) {
                            return false;
                        }
                        uri = uri.toLowerCase();
                        result = false;
                        if (this.matches != null) break block6;
                        String extension = FileNameUtil.getExtension(uri);
                        if (extension.length() <= 0 || StringUtil.equalsOne(extension = extension.toLowerCase(), this.extensions) == -1) break block7;
                        result = true;
                        break block7;
                    }
                    if (this.wildcards) {
                        result = Wildcard.matchPathOne(uri, this.matches) != -1;
                    } else {
                        for (String match : this.matches) {
                            if (!uri.contains(match)) continue;
                            result = true;
                            break;
                        }
                    }
                }
                if (!result || this.excludes == null) break block8;
                if (!this.wildcards) break block9;
                if (Wildcard.matchPathOne(uri, this.excludes) == -1) break block8;
                result = false;
                break block8;
            }
            for (String exclude : this.excludes) {
                if (!uri.contains(exclude)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

