/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHintsHandler {
    public static final String QUERY_HINT_PROPERTY = "eclipselink.query.hints";

    public static void verify(Map hints, String queryName, AbstractSession session) {
        if (hints == null) {
            return;
        }
        for (Map.Entry entry : hints.entrySet()) {
            String hintName = (String)entry.getKey();
            QueryHintsHandler.verify(hintName, entry.getValue(), queryName, session);
        }
    }

    public static void verify(String hintName, Object hintValue, String queryName, AbstractSession session) {
        Hint.verify(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, queryName, session);
    }

    public static DatabaseQuery apply(Map<String, Object> hints, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
        if (hints == null) {
            return query;
        }
        DatabaseQuery hintQuery = query;
        for (Map.Entry<String, Object> entry : hints.entrySet()) {
            String hintName = entry.getKey();
            if (entry.getValue() instanceof Object[]) {
                Object[] values = (Object[])entry.getValue();
                for (int index = 0; index < values.length; ++index) {
                    hintQuery = QueryHintsHandler.apply(hintName, values[index], hintQuery, loader, activeSession);
                }
                continue;
            }
            hintQuery = QueryHintsHandler.apply(hintName, entry.getValue(), hintQuery, loader, activeSession);
        }
        return hintQuery;
    }

    public static DatabaseQuery apply(String hintName, Object hintValue, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
        return Hint.apply(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, query, loader, activeSession);
    }

    public static boolean parseBooleanHint(Object hint) {
        if (hint == null) {
            return false;
        }
        return Boolean.valueOf(hint.toString());
    }

    public static int parseIntegerHint(Object hint, String hintName) {
        if (hint == null) {
            return -1;
        }
        try {
            return Integer.parseInt(hint.toString());
        }
        catch (NumberFormatException e) {
            throw QueryException.queryHintContainedInvalidIntegerValue(hintName, hint, e);
        }
    }

    protected static boolean shouldUseDefault(Object hintValue) {
        return hintValue != null && hintValue instanceof String && ((String)hintValue).length() == 0;
    }

    public static Set<String> getSupportedHints() {
        return Hint.getSupportedHints();
    }

    protected static class RedirectorHint
    extends Hint {
        RedirectorHint() {
            super("eclipselink.query.redirector", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            try {
                Object redirector = valueToApply;
                if (valueToApply instanceof Class) {
                    redirector = RedirectorHint.newInstance((Class)valueToApply, query, "eclipselink.query.redirector");
                } else if (valueToApply instanceof String) {
                    Class redirectorClass = RedirectorHint.loadClass((String)valueToApply, query, loader);
                    redirector = RedirectorHint.newInstance(redirectorClass, query, "eclipselink.query.redirector");
                }
                query.setRedirector((QueryRedirector)redirector);
            }
            catch (ClassCastException exception) {
                throw QueryException.unableToSetRedirectorOnQueryFromHint(query, "eclipselink.query.redirector", valueToApply.getClass().getName(), exception);
            }
            return query;
        }
    }

    protected static class ResultCollectionTypeHint
    extends Hint {
        ResultCollectionTypeHint() {
            super("eclipselink.result-collection-type", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isReadAllQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultCollectionTypeHint.getQueryId(query), this.name, ResultCollectionTypeHint.getPrintValue(valueToApply)}));
            }
            Class collectionClass = null;
            collectionClass = valueToApply instanceof String ? ResultCollectionTypeHint.loadClass((String)valueToApply, query, loader) : (Class)valueToApply;
            ((ReadAllQuery)query).useCollectionClass(collectionClass);
            return query;
        }
    }

    protected static class JDBCFirstResultHint
    extends Hint {
        JDBCFirstResultHint() {
            super("eclipselink.jdbc.first-result", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCFirstResultHint.getQueryId(query), this.name, JDBCFirstResultHint.getPrintValue(valueToApply)}));
            }
            ((ReadQuery)query).setFirstResult(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.jdbc.first-result"));
            return query;
        }
    }

    protected static class JDBCMaxRowsHint
    extends Hint {
        JDBCMaxRowsHint() {
            super("eclipselink.jdbc.max-rows", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCMaxRowsHint.getQueryId(query), this.name, JDBCMaxRowsHint.getPrintValue(valueToApply)}));
            }
            ((ReadQuery)query).setMaxRows(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.jdbc.max-rows"));
            return query;
        }
    }

    protected static class AsOfSCNHint
    extends Hint {
        AsOfSCNHint() {
            super("eclipselink.history.as-of.scn", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{AsOfSCNHint.getQueryId(query), this.name, AsOfSCNHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setAsOfClause(new AsOfSCNClause(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.history.as-of.scn")));
            return query;
        }
    }

    protected static class AsOfHint
    extends Hint {
        AsOfHint() {
            super("eclipselink.history.as-of", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{AsOfHint.getQueryId(query), this.name, AsOfHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setAsOfClause(new AsOfClause(Helper.timeFromString((String)valueToApply)));
            return query;
        }
    }

    protected static class JDBCFetchSizeHint
    extends Hint {
        JDBCFetchSizeHint() {
            super("eclipselink.jdbc.fetch-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCFetchSizeHint.getQueryId(query), this.name, JDBCFetchSizeHint.getPrintValue(valueToApply)}));
            }
            ((ReadQuery)query).setFetchSize(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.jdbc.fetch-size"));
            return query;
        }
    }

    protected static class JDBCTimeoutHint
    extends Hint {
        JDBCTimeoutHint() {
            super("eclipselink.jdbc.timeout", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setQueryTimeout(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.jdbc.timeout"));
            return query;
        }
    }

    protected static class HintHint
    extends Hint {
        HintHint() {
            super("eclipselink.sql.hint", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setHintString((String)valueToApply);
            return query;
        }
    }

    protected static class FlushHint
    extends Hint {
        FlushHint() {
            super("eclipselink.flush", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setFlushOnExecute((Boolean)valueToApply);
            return query;
        }
    }

    protected static class CacheStatementHint
    extends Hint {
        CacheStatementHint() {
            super("eclipselink.jdbc.cache-statement", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setShouldCacheStatement((Boolean)valueToApply);
            return query;
        }
    }

    protected static class PrepareHint
    extends Hint {
        PrepareHint() {
            super("eclipselink.prepare", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setShouldPrepare((Boolean)valueToApply);
            return query;
        }
    }

    protected static class MaintainCacheHint
    extends Hint {
        MaintainCacheHint() {
            super("eclipselink.maintain-cache", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setShouldMaintainCache((Boolean)valueToApply);
            return query;
        }
    }

    protected static class ScrollableCursorHint
    extends Hint {
        ScrollableCursorHint() {
            super("eclipselink.cursor.scrollable", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!((Boolean)valueToApply).booleanValue()) {
                if (query.isReadAllQuery()) {
                    if (((ReadAllQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                        ((ReadAllQuery)query).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                    }
                } else if (query.isDataReadQuery() && ((DataReadQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)query).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                }
            } else if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)query).useScrollableCursor();
                }
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)query).useScrollableCursor();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ScrollableCursorHint.getQueryId(query), this.name, ScrollableCursorHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class CursorSizeHint
    extends Hint {
        CursorSizeHint() {
            super("eclipselink.cursor.size-sql", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)query).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)query).getContainerPolicy()).setSizeQuery(new ValueReadQuery((String)valueToApply));
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)query).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)query).getContainerPolicy()).setSizeQuery(new ValueReadQuery((String)valueToApply));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorSizeHint.getQueryId(query), this.name, CursorSizeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class CursorPageSizeHint
    extends Hint {
        CursorPageSizeHint() {
            super("eclipselink.cursor.page-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isCursorPolicy()) {
                    ((ReadAllQuery)query).useCursoredStream();
                }
                ((CursorPolicy)((ReadAllQuery)query).getContainerPolicy()).setPageSize(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.cursor.page-size"));
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isCursorPolicy()) {
                    ((DataReadQuery)query).useCursoredStream();
                }
                ((CursorPolicy)((DataReadQuery)query).getContainerPolicy()).setPageSize(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.cursor.page-size"));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorPageSizeHint.getQueryId(query), this.name, CursorPageSizeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class CursorInitialSizeHint
    extends Hint {
        CursorInitialSizeHint() {
            super("eclipselink.cursor.initial-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)query).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)query).getContainerPolicy()).setInitialReadSize(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.cursor.initial-size"));
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)query).useCursoredStream();
                }
                ((CursoredStreamPolicy)((DataReadQuery)query).getContainerPolicy()).setInitialReadSize(QueryHintsHandler.parseIntegerHint(valueToApply, "eclipselink.cursor.initial-size"));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorInitialSizeHint.getQueryId(query), this.name, CursorInitialSizeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class CursorHint
    extends Hint {
        CursorHint() {
            super("eclipselink.cursor", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!((Boolean)valueToApply).booleanValue()) {
                if (query.isReadAllQuery()) {
                    if (((ReadAllQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                        ((ReadAllQuery)query).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                    }
                } else if (query.isDataReadQuery() && ((DataReadQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)query).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                }
            } else if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)query).useCursoredStream();
                }
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)query).useCursoredStream();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorHint.getQueryId(query), this.name, CursorHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class NativeConnectionHint
    extends Hint {
        NativeConnectionHint() {
            super("eclipselink.jdbc.native-connection", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setIsNativeConnectionRequired((Boolean)valueToApply);
            return query;
        }
    }

    protected static class ReadOnlyHint
    extends Hint {
        ReadOnlyHint() {
            super("eclipselink.read-only", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ReadOnlyHint.getQueryId(query), this.name, ReadOnlyHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setIsReadOnly((Boolean)valueToApply);
            return query;
        }
    }

    protected static class LeftFetchHint
    extends Hint {
        LeftFetchHint() {
            super("eclipselink.left-join-fetch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            Expression expression;
            ObjectLevelReadQuery olrq;
            if (query.isObjectLevelReadQuery() && !query.isReportQuery()) {
                olrq = (ObjectLevelReadQuery)query;
                StringTokenizer tokenizer = new StringTokenizer((String)valueToApply, ".");
                if (tokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(query, "eclipselink.left-join-fetch", valueToApply);
                }
                String previousToken = tokenizer.nextToken();
                olrq.checkDescriptor(activeSession);
                ClassDescriptor descriptor = olrq.getDescriptor();
                expression = olrq.getExpressionBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ForeignReferenceMapping frMapping = null;
                    DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(token);
                    if (mapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(query, "eclipselink.left-join-fetch", valueToApply, previousToken + "." + token);
                    }
                    if (!mapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(query, "eclipselink.left-join-fetch", valueToApply, previousToken + "." + token);
                    }
                    frMapping = (ForeignReferenceMapping)mapping;
                    descriptor = frMapping.getReferenceDescriptor();
                    expression = frMapping.isCollectionMapping() ? ((Expression)expression).anyOfAllowingNone(token) : expression.getAllowingNull(token);
                    previousToken = token;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{LeftFetchHint.getQueryId(query), this.name, LeftFetchHint.getPrintValue(valueToApply)}));
            }
            olrq.addJoinedAttribute(expression);
            return query;
        }
    }

    protected static class FetchHint
    extends Hint {
        FetchHint() {
            super("eclipselink.join-fetch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            Expression expression;
            ObjectLevelReadQuery olrq;
            if (query.isObjectLevelReadQuery() && !query.isReportQuery()) {
                olrq = (ObjectLevelReadQuery)query;
                StringTokenizer tokenizer = new StringTokenizer((String)valueToApply, ".");
                if (tokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(query, "eclipselink.join-fetch", valueToApply);
                }
                String previousToken = tokenizer.nextToken();
                olrq.checkDescriptor(activeSession);
                ClassDescriptor descriptor = olrq.getDescriptor();
                expression = olrq.getExpressionBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ForeignReferenceMapping frMapping = null;
                    DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(token);
                    if (mapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(query, "eclipselink.join-fetch", valueToApply, previousToken + "." + token);
                    }
                    if (!mapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(query, "eclipselink.join-fetch", valueToApply, previousToken + "." + token);
                    }
                    frMapping = (ForeignReferenceMapping)mapping;
                    descriptor = frMapping.getReferenceDescriptor();
                    expression = frMapping.isCollectionMapping() ? ((Expression)expression).anyOf(token) : expression.get(token);
                    previousToken = token;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchHint.getQueryId(query), this.name, FetchHint.getPrintValue(valueToApply)}));
            }
            olrq.addJoinedAttribute(expression);
            return query;
        }
    }

    protected static class BatchHint
    extends Hint {
        BatchHint() {
            super("eclipselink.batch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            Expression expression;
            ReadAllQuery raq;
            if (query.isReadAllQuery() && !query.isReportQuery()) {
                raq = (ReadAllQuery)query;
                StringTokenizer tokenizer = new StringTokenizer((String)valueToApply, ".");
                if (tokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(query, "eclipselink.batch", valueToApply);
                }
                String previousToken = tokenizer.nextToken();
                raq.checkDescriptor(activeSession);
                ClassDescriptor descriptor = raq.getDescriptor();
                expression = raq.getExpressionBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ForeignReferenceMapping frMapping = null;
                    DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(token);
                    if (mapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(query, "eclipselink.batch", valueToApply, previousToken + "." + token);
                    }
                    if (!mapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(query, "eclipselink.batch", valueToApply, previousToken + "." + token);
                    }
                    frMapping = (ForeignReferenceMapping)mapping;
                    descriptor = frMapping.getReferenceDescriptor();
                    expression = frMapping.isCollectionMapping() ? ((Expression)expression).anyOf(token) : expression.get(token);
                    previousToken = token;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{BatchHint.getQueryId(query), this.name, BatchHint.getPrintValue(valueToApply)}));
            }
            raq.addBatchReadAttribute(expression);
            return query;
        }
    }

    protected static class QueryCacheExpiryTimeOfDayHint
    extends Hint {
        QueryCacheExpiryTimeOfDayHint() {
            super("eclipselink.query-results-cache.expiry-time-of-day", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)query;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    Time time = Helper.timeFromString((String)valueToApply);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(time);
                    readQuery.getQueryResultsCachePolicy().setCacheInvalidationPolicy(new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), 0));
                }
                catch (ConversionException exception) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.expiry-time-of-day", valueToApply, exception);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheExpiryTimeOfDayHint.getQueryId(query), this.name, QueryCacheExpiryTimeOfDayHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class QueryCacheTypeHint
    extends Hint {
        QueryCacheTypeHint() {
            super("eclipselink.query-results-cache.type", "");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isReadQuery()) throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheTypeHint.getQueryId(query), this.name, QueryCacheTypeHint.getPrintValue(valueToApply)}));
            ReadQuery readQuery = (ReadQuery)query;
            if (readQuery.getQueryResultsCachePolicy() == null) {
                readQuery.cacheQueryResults();
            }
            if (valueToApply == null) return query;
            if (valueToApply.equals(CacheType.SOFT_WEAK.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.SoftCacheWeakIdentityMap_Class);
                return query;
            } else if (valueToApply.equals(CacheType.FULL.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.FullIdentityMap_Class);
                return query;
            } else if (valueToApply.equals(CacheType.WEAK.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.WeakIdentityMap_Class);
                return query;
            } else if (valueToApply.equals(CacheType.SOFT.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.SoftIdentityMap_Class);
                return query;
            } else if (valueToApply.equals(CacheType.HARD_WEAK.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.HardCacheWeakIdentityMap_Class);
                return query;
            } else if (valueToApply.equals(CacheType.CACHE.name())) {
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.CacheIdentityMap_Class);
                return query;
            } else {
                if (!valueToApply.equals(CacheType.NONE.name())) throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{QueryCacheTypeHint.getQueryId(query), this.name, QueryCacheTypeHint.getPrintValue(valueToApply)}));
                readQuery.getQueryResultsCachePolicy().setCacheType(ClassConstants.NoIdentityMap_Class);
            }
            return query;
        }
    }

    protected static class QueryCacheExpiryHint
    extends Hint {
        QueryCacheExpiryHint() {
            super("eclipselink.query-results-cache.expiry", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)query;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    readQuery.getQueryResultsCachePolicy().setCacheInvalidationPolicy(new TimeToLiveCacheInvalidationPolicy(Integer.parseInt((String)valueToApply)));
                }
                catch (NumberFormatException exception) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.expiry", valueToApply, exception);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheExpiryHint.getQueryId(query), this.name, QueryCacheExpiryHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class QueryCacheSizeHint
    extends Hint {
        QueryCacheSizeHint() {
            super("eclipselink.query-results-cache.size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)query;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    readQuery.getQueryResultsCachePolicy().setMaximumCachedResults(Integer.parseInt((String)valueToApply));
                }
                catch (NumberFormatException exception) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.size", valueToApply, exception);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheSizeHint.getQueryId(query), this.name, QueryCacheSizeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class QueryCacheRandomizedExpiryHint
    extends Hint {
        QueryCacheRandomizedExpiryHint() {
            super("eclipselink.query-results-cache.randomize-expiry", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                if (((ReadQuery)query).getQueryResultsCachePolicy() == null) {
                    ((ReadQuery)query).cacheQueryResults();
                }
                if (((ReadQuery)query).getQueryResultsCachePolicy().getCacheInvalidationPolicy() == null) {
                    ((ReadQuery)query).getQueryResultsCachePolicy().setCacheInvalidationPolicy(new TimeToLiveCacheInvalidationPolicy());
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheRandomizedExpiryHint.getQueryId(query), this.name, QueryCacheRandomizedExpiryHint.getPrintValue(valueToApply)}));
            }
            ((ReadQuery)query).getQueryResultsCachePolicy().getCacheInvalidationPolicy().setIsInvalidationRandomized((Boolean)valueToApply);
            return query;
        }
    }

    protected static class QueryCacheIgnoreNullHint
    extends Hint {
        QueryCacheIgnoreNullHint() {
            super("eclipselink.query-results-cache.ignore-null", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                if (((ReadQuery)query).getQueryResultsCachePolicy() == null) {
                    ((ReadQuery)query).cacheQueryResults();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheIgnoreNullHint.getQueryId(query), this.name, QueryCacheIgnoreNullHint.getPrintValue(valueToApply)}));
            }
            ((ReadQuery)query).getQueryResultsCachePolicy().setIsNullIgnored((Boolean)valueToApply);
            return query;
        }
    }

    protected static class QueryCacheHint
    extends Hint {
        QueryCacheHint() {
            super("eclipselink.query-results-cache", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isReadQuery()) {
                if (((Boolean)valueToApply).booleanValue() && ((ReadQuery)query).getQueryResultsCachePolicy() == null) {
                    ((ReadQuery)query).cacheQueryResults();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheHint.getQueryId(query), this.name, QueryCacheHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class FetchGroupAttributeHint
    extends Hint {
        FetchGroupAttributeHint() {
            super("eclipselink.fetch-group.attribute", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            FetchGroup fetchGroup;
            if (query.isObjectLevelReadQuery()) {
                fetchGroup = ((ObjectLevelReadQuery)query).getFetchGroup();
                if (fetchGroup == null) {
                    fetchGroup = new FetchGroup();
                    ((ObjectLevelReadQuery)query).setFetchGroup(fetchGroup);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupAttributeHint.getQueryId(query), this.name, FetchGroupAttributeHint.getPrintValue(valueToApply)}));
            }
            fetchGroup.addAttribute((String)valueToApply);
            return query;
        }
    }

    protected static class FetchGroupHint
    extends Hint {
        FetchGroupHint() {
            super("eclipselink.fetch-group", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupHint.getQueryId(query), this.name, FetchGroupHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setFetchGroup((FetchGroup)valueToApply);
            return query;
        }
    }

    protected static class FetchGroupNameHint
    extends Hint {
        FetchGroupNameHint() {
            super("eclipselink.fetch-group.name", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupNameHint.getQueryId(query), this.name, FetchGroupNameHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setFetchGroupName((String)valueToApply);
            return query;
        }
    }

    protected static class FetchGroupDefaultHint
    extends Hint {
        FetchGroupDefaultHint() {
            super("eclipselink.fetch-group.default", "True");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupDefaultHint.getQueryId(query), this.name, FetchGroupDefaultHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setShouldUseDefaultFetchGroup((Boolean)valueToApply);
            return query;
        }
    }

    protected static class InheritanceJoinHint
    extends Hint {
        InheritanceJoinHint() {
            super("eclipselink.inheritance.outer-join", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{InheritanceJoinHint.getQueryId(query), this.name, InheritanceJoinHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setShouldOuterJoinSubclasses((Boolean)valueToApply);
            return query;
        }
    }

    protected static class ExclusiveHint
    extends Hint {
        ExclusiveHint() {
            super("eclipselink.exclusive-connection", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ExclusiveHint.getQueryId(query), this.name, ExclusiveHint.getPrintValue(valueToApply)}));
            }
            ((ObjectBuildingQuery)query).setShouldUseExclusiveConnection((Boolean)valueToApply);
            return query;
        }
    }

    protected static class ResultSetConcurrencyHint
    extends Hint {
        ResultSetConcurrencyHint() {
            super("eclipselink.cursor.scrollable.result-set-concurrency", "Updatable");
            this.valueArray = new Object[][]{{"ReadOnly", 1007}, {"Updatable", 1008}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            int value = (Integer)valueToApply;
            if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)query).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((ReadAllQuery)query).getContainerPolicy()).setResultSetConcurrency(value);
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)query).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((DataReadQuery)query).getContainerPolicy()).setResultSetConcurrency(value);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultSetConcurrencyHint.getQueryId(query), this.name, ResultSetConcurrencyHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class ResultSetTypeHint
    extends Hint {
        ResultSetTypeHint() {
            super("eclipselink.cursor.scrollable.result-set-type", "ScrollInsensitive");
            this.valueArray = new Object[][]{{"Forward", 1000}, {"ForwardOnly", 1003}, {"Reverse", 1001}, {"ScrollInsensitive", 1004}, {"ScrollSensitive", 1005}, {"Unknown", 1002}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            int value = (Integer)valueToApply;
            if (query.isReadAllQuery()) {
                if (!((ReadAllQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)query).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((ReadAllQuery)query).getContainerPolicy()).setResultSetType(value);
            } else if (query.isDataReadQuery()) {
                if (!((DataReadQuery)query).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)query).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((DataReadQuery)query).getContainerPolicy()).setResultSetType(value);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultSetTypeHint.getQueryId(query), this.name, ResultSetTypeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class IndirectionPolicyHint
    extends Hint {
        IndirectionPolicyHint() {
            super("eclipselink.cache-usage.indirection-policy", "Exception");
            this.valueArray = new Object[][]{{"Conform", 2}, {"NotConform", 2}, {"Trigger", 1}, {"Exception", 0}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{IndirectionPolicyHint.getQueryId(query), this.name, IndirectionPolicyHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setInMemoryQueryIndirectionPolicyState((Integer)valueToApply);
            return query;
        }
    }

    protected static class ResultTypeHint
    extends Hint {
        ResultTypeHint() {
            super("eclipselink.result-type", "Array");
            this.valueArray = new Object[][]{{"Map", "Map"}, {"Array", "Array"}, {"Value", "Value"}, {"Attribute", "Attribute"}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isDataReadQuery()) {
                if (valueToApply == "Map") {
                    ((DataReadQuery)query).setResultType(0);
                } else if (valueToApply == "Array") {
                    ((DataReadQuery)query).setResultType(1);
                } else if (valueToApply == "Attribute") {
                    ((DataReadQuery)query).setResultType(3);
                } else if (valueToApply == "Value") {
                    ((DataReadQuery)query).setResultType(2);
                }
            } else if (query.isReportQuery()) {
                if (valueToApply == "Map") {
                    ((ReportQuery)query).setReturnType(0);
                } else if (valueToApply == "Array") {
                    ((ReportQuery)query).setReturnType(5);
                } else if (valueToApply == "Attribute") {
                    ((ReportQuery)query).setReturnType(3);
                } else if (valueToApply == "Value") {
                    ((ReportQuery)query).setReturnType(2);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultTypeHint.getQueryId(query), this.name, ResultTypeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class RefreshHint
    extends Hint {
        RefreshHint() {
            super("eclipselink.refresh", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{RefreshHint.getQueryId(query), this.name, RefreshHint.getPrintValue(valueToApply)}));
            }
            ((ObjectBuildingQuery)query).setShouldRefreshIdentityMapResult((Boolean)valueToApply);
            return query;
        }
    }

    protected static class PessimisticLockTimeoutHint
    extends Hint {
        PessimisticLockTimeoutHint() {
            super("javax.persistence.lock.timeout", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{PessimisticLockTimeoutHint.getQueryId(query), this.name, PessimisticLockTimeoutHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setWaitTimeout(QueryHintsHandler.parseIntegerHint(valueToApply, "javax.persistence.lock.timeout"));
            return query;
        }
    }

    protected static class PessimisticLockScope
    extends Hint {
        PessimisticLockScope() {
            super("javax.persistence.lock.scope", javax.persistence.PessimisticLockScope.NORMAL.name());
            this.valueArray = new Object[]{javax.persistence.PessimisticLockScope.NORMAL.name(), javax.persistence.PessimisticLockScope.EXTENDED.name()};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isObjectLevelReadQuery()) {
                boolean shouldExtend = valueToApply.equals(javax.persistence.PessimisticLockScope.EXTENDED.name());
                ObjectLevelReadQuery olrQuery = (ObjectLevelReadQuery)query;
                olrQuery.setShouldExtendPessimisticLockScope(shouldExtend);
                if (shouldExtend) {
                    olrQuery.extendPessimisticLockScope();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{PessimisticLockScope.getQueryId(query), this.name, PessimisticLockScope.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class PessimisticLockHint
    extends Hint {
        PessimisticLockHint() {
            super("eclipselink.pessimistic-lock", "NoLock");
            this.valueArray = new Object[][]{{"NoLock", (short)0}, {"Lock", (short)1}, {"LockNoWait", (short)2}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (!query.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{PessimisticLockHint.getQueryId(query), this.name, PessimisticLockHint.getPrintValue(valueToApply)}));
            }
            ((ObjectBuildingQuery)query).setLockMode((Short)valueToApply);
            return query;
        }
    }

    protected static class QueryTypeHint
    extends Hint {
        QueryTypeHint() {
            super("eclipselink.query-type", "Auto");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (valueToApply.equals("Auto")) {
                return query;
            }
            DatabaseQuery newQuery = query;
            if (valueToApply.equals("ReadAll")) {
                newQuery = new ReadAllQuery();
            } else if (valueToApply.equals("ReadObject")) {
                newQuery = new ReadObjectQuery();
            } else if (valueToApply.equals("Report")) {
                newQuery = new ReportQuery();
                if (query.isObjectLevelReadQuery()) {
                    ((ReportQuery)newQuery).addAttribute("root", ((ReportQuery)newQuery).getExpressionBuilder());
                }
            } else if (valueToApply.equals("ResultSetMapping")) {
                newQuery = new ResultSetMappingQuery();
            } else if (valueToApply.equals("UpdateAll")) {
                newQuery = new UpdateAllQuery();
            } else if (valueToApply.equals("DeleteAll")) {
                newQuery = new DeleteAllQuery();
            } else if (valueToApply.equals("DataModify")) {
                newQuery = new DataModifyQuery();
            } else if (valueToApply.equals("DataRead")) {
                newQuery = new DataReadQuery();
            } else if (valueToApply.equals("DirectRead")) {
                newQuery = new DirectReadQuery();
            } else if (valueToApply.equals("ValueRead")) {
                newQuery = new ValueReadQuery();
            } else {
                Class queryClass = QueryTypeHint.loadClass((String)valueToApply, query, loader);
                newQuery = (DatabaseQuery)QueryTypeHint.newInstance(queryClass, query, "eclipselink.query-type");
            }
            newQuery.copyFromQuery(query);
            return newQuery;
        }
    }

    protected static class CascadePolicyHint
    extends Hint {
        CascadePolicyHint() {
            super("eclipselink.refresh.cascade", "CascadeByMapping");
            this.valueArray = new Object[][]{{"NoCascading", 1}, {"CascadePrivateParts", 2}, {"CascadeAllParts", 3}, {"CascadeByMapping", 6}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            query.setCascadePolicy((Integer)valueToApply);
            return query;
        }
    }

    protected static class CacheUsageHint
    extends Hint {
        CacheUsageHint() {
            super("eclipselink.cache-usage", "UseEntityDefault");
            this.valueArray = new Object[][]{{"UseEntityDefault", -1}, {"DoNotCheckCache", 0}, {"CheckCacheByExactPrimaryKey", 1}, {"CheckCacheByPrimaryKey", 2}, {"CheckCacheThenDatabase", 3}, {"CheckCacheOnly", 4}, {"ConformResultsInUnitOfWork", 5}, {"NoCache", 0}, {"Invalidate", 1}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isObjectLevelReadQuery()) {
                int cacheUsage = (Integer)valueToApply;
                ((ObjectLevelReadQuery)query).setCacheUsage(cacheUsage);
                if (cacheUsage == 1 || cacheUsage == 2 || cacheUsage == 3) {
                    ReadObjectQuery newQuery = new ReadObjectQuery();
                    newQuery.copyFromQuery(query);
                    return newQuery;
                }
            } else if (query.isModifyAllQuery()) {
                int cacheUsage = (Integer)valueToApply;
                ((ModifyAllQuery)query).setCacheUsage(cacheUsage);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CacheUsageHint.getQueryId(query), this.name, CacheUsageHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class CacheStoreModeHint
    extends Hint {
        CacheStoreModeHint() {
            super("javax.persistence.cacheStoreMode", CacheStoreMode.USE.name());
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (valueToApply.equals((Object)CacheStoreMode.BYPASS) || valueToApply.equals(CacheStoreMode.BYPASS.name())) {
                query.storeBypassCache();
            } else if (valueToApply.equals((Object)CacheStoreMode.REFRESH) || valueToApply.equals(CacheStoreMode.REFRESH.name())) {
                if (query.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)query).refreshIdentityMapResult();
                } else {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CacheStoreModeHint.getQueryId(query), this.name, CacheStoreModeHint.getPrintValue(valueToApply)}));
                }
            }
            return query;
        }
    }

    protected static class CacheRetrieveModeHint
    extends Hint {
        CacheRetrieveModeHint() {
            super("javax.persistence.cacheRetrieveMode", CacheRetrieveMode.USE.name());
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (query.isObjectLevelReadQuery()) {
                if (valueToApply.equals((Object)CacheRetrieveMode.BYPASS) || valueToApply.equals(CacheRetrieveMode.BYPASS.name())) {
                    query.retrieveBypassCache();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CacheRetrieveModeHint.getQueryId(query), this.name, CacheRetrieveModeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class BindParametersHint
    extends Hint {
        BindParametersHint() {
            super("eclipselink.jdbc.bind-parameters", "PersistenceUnitDefault");
            this.valueArray = new Object[][]{{"PersistenceUnitDefault", null}, {"True", Boolean.TRUE}, {"False", Boolean.FALSE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            if (valueToApply == null) {
                query.ignoreBindAllParameters();
            } else {
                query.setShouldBindAllParameters((boolean)((Boolean)valueToApply));
            }
            return query;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Hint {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        Object defaultValueToApply;
        boolean valueToApplyMayBeNull;

        Hint(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        abstract DatabaseQuery applyToDatabaseQuery(Object var1, DatabaseQuery var2, ClassLoader var3, AbstractSession var4);

        static void verify(String hintName, boolean shouldUseDefault, Object hintValue, String queryName, AbstractSession session) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                if (session != null) {
                    session.log(1, "query", "unknown_query_hint", new Object[]{Hint.getPrintValue(queryName), hintName});
                }
                return;
            }
            hint.verify(hintValue, shouldUseDefault, queryName, session);
        }

        void verify(Object hintValue, boolean shouldUseDefault, String queryName, AbstractSession session) {
            if (shouldUseDefault) {
                hintValue = this.defaultValue;
            }
            if (session != null) {
                session.log(1, "query", "query_hint", new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)});
            }
            if (!shouldUseDefault && this.valueMap != null && !this.valueMap.containsKey(Hint.getUpperCaseString(hintValue))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)}));
            }
        }

        static DatabaseQuery apply(String hintName, boolean shouldUseDefault, Object hintValue, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                return query;
            }
            HashMap<String, Object> existingHints = (HashMap<String, Object>)query.getProperty(QueryHintsHandler.QUERY_HINT_PROPERTY);
            if (existingHints == null) {
                existingHints = new HashMap<String, Object>();
                query.setProperty(QueryHintsHandler.QUERY_HINT_PROPERTY, existingHints);
            }
            existingHints.put(hintName, hintValue);
            return hint.apply(hintValue, shouldUseDefault, query, loader, activeSession);
        }

        DatabaseQuery apply(Object hintValue, boolean shouldUseDefault, DatabaseQuery query, ClassLoader loader, AbstractSession activeSession) {
            String key;
            Object valueToApply = hintValue;
            if (shouldUseDefault) {
                valueToApply = this.defaultValueToApply;
            } else if (this.valueMap != null && (valueToApply = this.valueMap.get(key = Hint.getUpperCaseString(hintValue))) == null) {
                boolean wrongKey = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = wrongKey = !this.valueMap.containsKey(key);
                }
                if (wrongKey) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getQueryId(query), this.name, Hint.getPrintValue(hintValue)}));
                }
            }
            return this.applyToDatabaseQuery(valueToApply, query, loader, activeSession);
        }

        static String getQueryId(DatabaseQuery query) {
            String queryId = query.getName();
            if (queryId == null) {
                queryId = query.getEJBQLString();
            }
            return Hint.getPrintValue(queryId);
        }

        static String getPrintValue(Object hintValue) {
            return hintValue != null ? hintValue.toString() : "null";
        }

        static String getUpperCaseString(Object hintValue) {
            return hintValue != null ? hintValue.toString().toUpperCase() : null;
        }

        static Class loadClass(String className, DatabaseQuery query, ClassLoader loader) throws QueryException {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.classNotFoundWhileUsingQueryHint(query, className, exception.getException());
                    }
                }
                return PrivilegedAccessHelper.getClassForName(className, true, loader);
            }
            catch (ClassNotFoundException exception) {
                throw QueryException.classNotFoundWhileUsingQueryHint(query, className, exception);
            }
        }

        static Object newInstance(Class theClass, DatabaseQuery query, String hint) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(theClass));
                }
                return PrivilegedAccessHelper.newInstanceFromClass(theClass);
            }
            catch (Exception exception) {
                throw QueryException.errorInstantiatedClassForQueryHint(exception, query, theClass, hint);
            }
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = this.valueMap.get(this.defaultValue.toUpperCase());
            }
        }

        static void addHint(Hint hint) {
            hint.initialize();
            mainMap.put(hint.name, hint);
        }

        static Set<String> getSupportedHints() {
            return mainMap.keySet();
        }

        static {
            Hint.addHint(new BindParametersHint());
            Hint.addHint(new CacheUsageHint());
            Hint.addHint(new CacheRetrieveModeHint());
            Hint.addHint(new CacheStoreModeHint());
            Hint.addHint(new QueryTypeHint());
            Hint.addHint(new PessimisticLockHint());
            Hint.addHint(new PessimisticLockScope());
            Hint.addHint(new PessimisticLockTimeoutHint());
            Hint.addHint(new RefreshHint());
            Hint.addHint(new CascadePolicyHint());
            Hint.addHint(new BatchHint());
            Hint.addHint(new FetchHint());
            Hint.addHint(new LeftFetchHint());
            Hint.addHint(new ReadOnlyHint());
            Hint.addHint(new JDBCTimeoutHint());
            Hint.addHint(new JDBCFetchSizeHint());
            Hint.addHint(new JDBCMaxRowsHint());
            Hint.addHint(new JDBCFirstResultHint());
            Hint.addHint(new ResultCollectionTypeHint());
            Hint.addHint(new RedirectorHint());
            Hint.addHint(new QueryCacheHint());
            Hint.addHint(new QueryCacheSizeHint());
            Hint.addHint(new QueryCacheExpiryHint());
            Hint.addHint(new QueryCacheExpiryTimeOfDayHint());
            Hint.addHint(new MaintainCacheHint());
            Hint.addHint(new PrepareHint());
            Hint.addHint(new CacheStatementHint());
            Hint.addHint(new FlushHint());
            Hint.addHint(new HintHint());
            Hint.addHint(new NativeConnectionHint());
            Hint.addHint(new CursorHint());
            Hint.addHint(new CursorInitialSizeHint());
            Hint.addHint(new CursorPageSizeHint());
            Hint.addHint(new ScrollableCursorHint());
            Hint.addHint(new CursorSizeHint());
            Hint.addHint(new FetchGroupHint());
            Hint.addHint(new FetchGroupNameHint());
            Hint.addHint(new FetchGroupDefaultHint());
            Hint.addHint(new FetchGroupAttributeHint());
            Hint.addHint(new ExclusiveHint());
            Hint.addHint(new InheritanceJoinHint());
            Hint.addHint(new AsOfHint());
            Hint.addHint(new AsOfSCNHint());
            Hint.addHint(new ResultTypeHint());
            Hint.addHint(new ResultSetTypeHint());
            Hint.addHint(new ResultSetConcurrencyHint());
            Hint.addHint(new IndirectionPolicyHint());
            Hint.addHint(new QueryCacheTypeHint());
            Hint.addHint(new QueryCacheIgnoreNullHint());
            Hint.addHint(new QueryCacheRandomizedExpiryHint());
        }
    }
}

