/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.AbstractHttpRequestHandlerBeanDefinitionParser;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.w3c.dom.Element;

class ResourcesBeanDefinitionParser
extends AbstractHttpRequestHandlerBeanDefinitionParser
implements BeanDefinitionParser {
    ResourcesBeanDefinitionParser() {
    }

    public void doParse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        this.registerResourceMappings(parserContext, element, source);
    }

    private void registerResourceMappings(ParserContext parserContext, Element element, Object source) {
        String resourceHandlerName = this.registerResourceHandler(parserContext, element, source);
        if (resourceHandlerName == null) {
            return;
        }
        ManagedMap urlMap = new ManagedMap();
        String resourceRequestPath = element.getAttribute("mapping");
        if (!StringUtils.hasText((String)resourceRequestPath)) {
            parserContext.getReaderContext().error("The 'mapping' attribute is required.", parserContext.extractSource((Object)element));
            return;
        }
        urlMap.put(resourceRequestPath, resourceHandlerName);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        String order = element.getAttribute("order");
        handlerMappingDef.getPropertyValues().add("order", StringUtils.hasText((String)order) ? order : Integer.valueOf(0x7FFFFFFE));
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)handlerMappingDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)handlerMappingDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, beanName));
    }

    private String registerResourceHandler(ParserContext parserContext, Element element, Object source) {
        String locationAttr = element.getAttribute("location");
        if (!StringUtils.hasText((String)locationAttr)) {
            parserContext.getReaderContext().error("The 'location' attribute is required.", parserContext.extractSource((Object)element));
            return null;
        }
        RootBeanDefinition resourceHandlerDef = new RootBeanDefinition(ResourceHttpRequestHandler.class);
        resourceHandlerDef.setSource(source);
        resourceHandlerDef.setRole(2);
        resourceHandlerDef.getPropertyValues().add("locations", (Object)StringUtils.commaDelimitedListToStringArray((String)locationAttr));
        String cacheSeconds = element.getAttribute("cache-period");
        if (StringUtils.hasText((String)cacheSeconds)) {
            resourceHandlerDef.getPropertyValues().add("cacheSeconds", (Object)cacheSeconds);
        }
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)resourceHandlerDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)resourceHandlerDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)resourceHandlerDef, beanName));
        return beanName;
    }
}

