/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jndi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.StringUtil;
import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    private static Log _log = LogFactoryUtil.getLog(JNDIUtil.class);

    public static Object lookup(Context context, String location) throws NamingException {
        return JNDIUtil._lookup(context, location);
    }

    public static Object lookup(Context context, String location, boolean cache) throws NamingException {
        return JNDIUtil._lookup(context, location);
    }

    private static Object _lookup(Context context, String location) throws NamingException {
        PortalRuntimePermission.checkGetBeanProperty(JNDIUtil.class);
        if (_log.isDebugEnabled()) {
            _log.debug("Lookup " + location);
        }
        Object obj = null;
        try {
            obj = context.lookup(location);
        }
        catch (NamingException ne1) {
            if (location.contains("java:comp/env/")) {
                try {
                    String newLocation = StringUtil.replace(location, "java:comp/env/", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
                catch (NamingException ne2) {
                    String newLocation = StringUtil.replace(location, "comp/env/", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
            }
            if (location.contains("java:")) {
                try {
                    String newLocation = StringUtil.replace(location, "java:", "");
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
                catch (NamingException ne2) {
                    String newLocation = StringUtil.replace(location, "java:", "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
            }
            if (!location.contains("java:")) {
                try {
                    String newLocation = "java:" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
                catch (NamingException ne2) {
                    String newLocation = "java:comp/env/" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(ne2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    obj = context.lookup(newLocation);
                }
            }
            throw new NamingException();
        }
        return obj;
    }
}

