/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PollerRequest {
    private String _chunkId;
    private Map<String, String> _parameterMap = Collections.emptyMap();
    private PollerHeader _pollerHeader;
    private String _portletId;
    private boolean _receiveRequest;
    private HttpServletRequest _request;

    public PollerRequest(HttpServletRequest request, PollerHeader pollerHeader, String portletId, Map<String, String> parameterMap, String chunkId, boolean receiveRequest) {
        this._request = request;
        this._pollerHeader = pollerHeader;
        this._portletId = portletId;
        this._parameterMap = parameterMap;
        this._chunkId = chunkId;
        this._receiveRequest = receiveRequest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PollerRequest)) {
            return false;
        }
        PollerRequest portletRequest = (PollerRequest)obj;
        return Validator.equals(this._portletId, portletRequest._portletId);
    }

    public long getBrowserKey() {
        return this._pollerHeader.getBrowserKey();
    }

    public String getChunkId() {
        return this._chunkId;
    }

    public long getCompanyId() {
        return this._pollerHeader.getCompanyId();
    }

    public Map<String, String> getParameterMap() {
        return this._parameterMap;
    }

    public PollerHeader getPollerHeader() {
        return this._pollerHeader;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public Set<String> getPortletIds() {
        Map<String, Boolean> portletIdsMap = this._pollerHeader.getPortletIdsMap();
        return portletIdsMap.keySet();
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public long getTimestamp() {
        return this._pollerHeader.getTimestamp();
    }

    public long getUserId() {
        return this._pollerHeader.getUserId();
    }

    public int hashCode() {
        if (this._portletId != null) {
            return this._portletId.hashCode();
        }
        return 0;
    }

    public boolean isInitialRequest() {
        Map<String, Boolean> portletIdsMap = this._pollerHeader.getPortletIdsMap();
        return portletIdsMap.get(this._portletId);
    }

    public boolean isReceiveRequest() {
        return this._receiveRequest;
    }

    public boolean isStartPolling() {
        return this._pollerHeader.isStartPolling();
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{chunkId=");
        sb.append(this._chunkId);
        sb.append(", parameterMap=");
        sb.append(this._parameterMap);
        sb.append(", pollerHeader=");
        sb.append(this._pollerHeader);
        sb.append(", portletId=");
        sb.append(this._portletId);
        sb.append(", receiveRequest=");
        sb.append(this._receiveRequest);
        sb.append("}");
        return sb.toString();
    }
}

