/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.jaas;

import com.liferay.portal.kernel.security.jaas.PortalPrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class PortalGroup
extends PortalPrincipal
implements Group,
Serializable {
    private Map<Principal, Principal> _members = new HashMap<Principal, Principal>();

    public PortalGroup(String groupName) {
        super(groupName);
    }

    public boolean addMember(Principal user) {
        if (!this._members.containsKey(user)) {
            this._members.put(user, user);
            return true;
        }
        return false;
    }

    public boolean isMember(Principal member) {
        if (this._members.containsKey(member)) {
            return true;
        }
        for (Principal principal : this._members.values()) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)principal).isMember(member)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Principal> members() {
        return Collections.enumeration(this._members.values());
    }

    public boolean removeMember(Principal user) {
        Principal principal = this._members.remove(user);
        return principal != null;
    }
}

