/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.LiferayFilterTracker;
import com.liferay.portal.kernel.servlet.filters.invoker.FilterMapping;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseFilter
implements LiferayFilter {
    private static final String _DEPTHER = "DEPTHER";
    private static final boolean _TCK_URL = GetterUtil.getBoolean(PropsUtil.get("tck.url"));
    private FilterConfig _filterConfig;
    private boolean _filterEnabled = true;
    private FilterMapping _filterMapping;
    private boolean _invokerEnabled = true;

    public void destroy() {
        LiferayFilterTracker.removeLiferayFilter(this);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (this._invokerEnabled) {
                this.processFilter(request, response, filterChain);
            } else {
                String uri = request.getRequestURI();
                if (this.isFilterEnabled() && this.isFilterEnabled(request, response) && this._filterMapping.isMatchURLRegexPattern(request, uri)) {
                    this.processFilter(request, response, filterChain);
                } else {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Exception e) {
            Log log = this.getLog();
            log.error(e, e);
        }
    }

    public FilterConfig getFilterConfig() {
        return this._filterConfig;
    }

    public void init(FilterConfig filterConfig) {
        this._filterConfig = filterConfig;
        if (_TCK_URL) {
            ServletContext servletContext = this._filterConfig.getServletContext();
            this._invokerEnabled = GetterUtil.get(servletContext.getInitParameter("liferay-invoker-enabled"), true);
            if (!this._invokerEnabled) {
                this._filterMapping = new FilterMapping(this, filterConfig, new ArrayList<String>(0), new ArrayList<String>(0));
            }
        }
        LiferayFilterTracker.addLiferayFilter(this);
    }

    @Override
    public boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this._filterEnabled;
    }

    @Override
    public void setFilterEnabled(boolean filterEnabled) {
        this._filterEnabled = filterEnabled;
    }

    protected abstract Log getLog();

    protected void processFilter(Class<?> filterClass, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long startTime = 0L;
        String threadName = null;
        String depther = null;
        String path = null;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            threadName = currentThread.getName();
            depther = (String)request.getAttribute(_DEPTHER);
            depther = depther == null ? "" : String.valueOf(depther) + "=";
            request.setAttribute(_DEPTHER, (Object)depther);
            path = request.getRequestURI();
            log.debug("[" + threadName + "]" + depther + "> " + filterClass.getName() + " " + path);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (!log.isDebugEnabled()) {
            return;
        }
        long endTime = System.currentTimeMillis();
        depther = (String)request.getAttribute(_DEPTHER);
        if (depther == null) {
            return;
        }
        log.debug("[" + threadName + "]" + depther + "< " + filterClass.getName() + " " + path + " " + (endTime - startTime) + " ms");
        if (depther.length() > 0) {
            depther = depther.substring(1);
        }
        request.setAttribute(_DEPTHER, (Object)depther);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        throw new UnsupportedOperationException("Please implement processFilter(HttpServletRequest, HttpServletResponse, FilterChain)");
    }
}

