/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class InetAddressUtil {
    private static Log _log = LogFactoryUtil.getLog(InetAddressUtil.class);

    public static String getLocalHostName() throws Exception {
        return LocalHostNameHolder._localHostName;
    }

    public static InetAddress getLocalInetAddress() throws Exception {
        String clusterNodeListenAddress;
        block5: {
            clusterNodeListenAddress = "";
            try {
                clusterNodeListenAddress = GetterUtil.getString(PropsUtil.get("cluster.node.listen.address"));
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(e, e);
            }
        }
        if (Validator.isNotNull(clusterNodeListenAddress)) {
            InetAddress inetAddress = InetAddress.getByName(clusterNodeListenAddress);
            return inetAddress;
        }
        Enumeration<NetworkInterface> enu1 = NetworkInterface.getNetworkInterfaces();
        while (enu1.hasMoreElements()) {
            NetworkInterface networkInterface = enu1.nextElement();
            Enumeration<InetAddress> enu2 = networkInterface.getInetAddresses();
            while (enu2.hasMoreElements()) {
                InetAddress inetAddress = enu2.nextElement();
                if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                return inetAddress;
            }
        }
        throw new SystemException("No local internet address");
    }

    public static InetAddress getLoopbackInetAddress() throws UnknownHostException {
        return InetAddress.getByName("127.0.0.1");
    }

    private static class LocalHostNameHolder {
        private static final String _localHostName;

        static {
            try {
                InetAddress inetAddress = InetAddressUtil.getLocalInetAddress();
                _localHostName = inetAddress.getHostName();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        private LocalHostNameHolder() {
        }
    }
}

