/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessInputStream
extends InputStream {
    private File _file;
    private boolean _foundEOF;
    private InputStream _inputStream;
    private long _length;
    private long _markPosition = -1L;
    private long _pointer;
    private RandomAccessFile _randomAccessFileCache;

    public RandomAccessInputStream(InputStream inputStream) throws IOException {
        this._inputStream = inputStream;
        this._file = FileUtil.createTempFile();
        this._randomAccessFileCache = new RandomAccessFile(this._file, "rw");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._randomAccessFileCache.close();
        FileUtil.delete(this._file);
    }

    @Override
    public synchronized void mark(int readLimit) {
        this._markPosition = this._pointer;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        long next = this._pointer + 1L;
        long position = this.readUntil(next);
        if (position >= next) {
            this._randomAccessFileCache.seek(this._pointer++);
            return this._randomAccessFileCache.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        long position = this.readUntil(this._pointer + (long)length);
        if ((length = (int)Math.min((long)length, position - this._pointer)) > 0) {
            this._randomAccessFileCache.seek(this._pointer);
            this._randomAccessFileCache.readFully(bytes, offset, length);
            this._pointer += (long)length;
            return length;
        }
        return -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this._markPosition != -1L) {
            this.seek(this._markPosition);
        }
    }

    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Error while seeking stream");
        }
        this._pointer = position;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected long readUntil(long position) throws IOException {
        if (position < this._length) {
            return position;
        }
        if (this._foundEOF) {
            return this._length;
        }
        long lengthToRead = position - this._length;
        this._randomAccessFileCache.seek(this._length);
        byte[] buffer = new byte[1024];
        while (lengthToRead > 0L) {
            int bytesRead = this._inputStream.read(buffer, 0, (int)Math.min(lengthToRead, (long)buffer.length));
            if (bytesRead == -1) {
                this._foundEOF = true;
                return this._length;
            }
            this._randomAccessFileCache.setLength(this._randomAccessFileCache.length() + (long)bytesRead);
            this._randomAccessFileCache.write(buffer, 0, bytesRead);
            lengthToRead -= (long)bytesRead;
            this._length += (long)bytesRead;
        }
        return position;
    }
}

