/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplay;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class BaseDDMDisplay
implements DDMDisplay {
    private static Set<String> _templateLanguageTypes = SetUtil.fromArray(new String[]{"ftl", "vm"});
    private static Set<String> _viewTemplateExcludedColumnNames = SetUtil.fromArray(new String[]{"structure"});

    @Override
    public String getAddStructureActionId() {
        return "ADD_STRUCTURE";
    }

    @Override
    public String getAddTemplateActionId() {
        return "ADD_TEMPLATE";
    }

    @Override
    public String getAvailableFields() {
        return "Liferay.FormBuilder.AVAILABLE_FIELDS.DDM_STRUCTURE";
    }

    @Override
    public String getEditStructureDefaultValuesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, DDMStructure structure, String redirectURL, String backURL) throws Exception {
        return null;
    }

    @Override
    public String getEditTemplateBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK, String portletResource) throws Exception {
        String redirect = ParamUtil.getString(liferayPortletRequest, "redirect");
        if (Validator.isNull(redirect) || Validator.isNull(portletResource)) {
            return this.getViewTemplatesURL(liferayPortletRequest, liferayPortletResponse, classNameId, classPK);
        }
        return redirect;
    }

    @Override
    public String getEditTemplateTitle(DDMStructure structure, DDMTemplate template, Locale locale) {
        if (structure != null && template != null) {
            StringBundler sb = new StringBundler(5);
            sb.append(template.getName(locale));
            sb.append(" ");
            sb.append("(");
            sb.append(structure.getName(locale));
            sb.append(")");
            return sb.toString();
        }
        if (structure != null) {
            return LanguageUtil.format(locale, "new-template-for-structure-x", (Object)structure.getName(locale), false);
        }
        if (template != null) {
            return template.getName(locale);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getEditTemplateTitle(long classNameId, Locale locale) {
        TemplateHandler templateHandler;
        if (classNameId > 0L && (templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler(classNameId)) != null) {
            return String.valueOf(LanguageUtil.get(locale, "new")) + " " + templateHandler.getName(locale);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getResourceName(long classNameId) {
        TemplateHandler templateHandler;
        if (classNameId > 0L && (templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler(classNameId)) != null) {
            return templateHandler.getResourceName();
        }
        return this.getResourceName();
    }

    @Override
    public String getStorageType() {
        return "";
    }

    @Override
    public String getStructureName(Locale locale) {
        return LanguageUtil.get(locale, "structure");
    }

    @Override
    public String getStructureType() {
        return "";
    }

    @Override
    public long[] getTemplateClassNameIds(long classNameId) {
        if (classNameId > 0L) {
            return new long[]{classNameId};
        }
        return TemplateHandlerRegistryUtil.getClassNameIds();
    }

    @Override
    public long[] getTemplateClassPKs(long companyId, long classNameId, long classPK) throws Exception {
        if (classPK > 0L) {
            return new long[]{classPK};
        }
        ArrayList<Long> classPKs = new ArrayList<Long>();
        classPKs.add(0L);
        List<DDMStructure> structures = DDMStructureLocalServiceUtil.getClassStructures(companyId, PortalUtil.getClassNameId(this.getStructureType()));
        for (DDMStructure structure : structures) {
            classPKs.add(structure.getPrimaryKey());
        }
        return ArrayUtil.toLongArray(classPKs);
    }

    @Override
    public long[] getTemplateGroupIds(ThemeDisplay themeDisplay, boolean showGlobalScope) throws Exception {
        if (showGlobalScope) {
            return PortalUtil.getSiteAndCompanyGroupIds(themeDisplay);
        }
        return new long[]{themeDisplay.getScopeGroupId()};
    }

    @Override
    public long getTemplateHandlerClassNameId(DDMTemplate template, long classNameId) {
        if (template != null) {
            return template.getClassNameId();
        }
        return classNameId;
    }

    @Override
    public Set<String> getTemplateLanguageTypes() {
        return _templateLanguageTypes;
    }

    @Override
    public String getTemplateMode() {
        return "";
    }

    @Override
    public String getTemplateType() {
        return "";
    }

    @Override
    public String getTemplateType(DDMTemplate template, Locale locale) {
        return LanguageUtil.get(locale, template.getType());
    }

    @Override
    public String getViewTemplatesBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classPK) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "166", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/view");
        return portletURL.toString();
    }

    @Override
    public Set<String> getViewTemplatesExcludedColumnNames() {
        return _viewTemplateExcludedColumnNames;
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, boolean controlPanel, Locale locale) {
        if (structure != null) {
            return LanguageUtil.format(locale, "templates-for-structure-x", (Object)structure.getName(locale), false);
        }
        return this.getDefaultViewTemplateTitle(locale);
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, Locale locale) {
        return this.getViewTemplatesTitle(structure, false, locale);
    }

    @Override
    public boolean isShowAddStructureButton() {
        String portletId = this.getPortletId();
        return !portletId.equals("166");
    }

    @Override
    public boolean isShowStructureSelector() {
        return false;
    }

    protected long getControlPanelPlid(LiferayPortletRequest liferayPortletRequest) throws PortalException, SystemException {
        return PortalUtil.getControlPanelPlid(liferayPortletRequest);
    }

    protected String getDefaultEditTemplateTitle(Locale locale) {
        return LanguageUtil.get(locale, "new-template");
    }

    protected String getDefaultViewTemplateTitle(Locale locale) {
        return LanguageUtil.get(locale, "templates");
    }

    protected String getViewTemplatesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "166", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/view_template");
        portletURL.setParameter("classNameId", String.valueOf(classNameId));
        portletURL.setParameter("classPK", String.valueOf(classPK));
        return portletURL.toString();
    }
}

