/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.common.ServletContextProvider;
import org.apache.portals.bridges.struts.PortletServletRequestWrapper;
import org.apache.portals.bridges.struts.StrutsPortletErrorContext;
import org.apache.portals.bridges.struts.StrutsPortletURL;
import org.apache.portals.bridges.struts.config.StrutsPortletConfig;
import org.apache.portals.bridges.struts.util.EmptyHttpServletResponseWrapper;

public class StrutsPortlet
extends GenericPortlet {
    public static final String PARAM_SERVLET_CONTEXT_PROVIDER = "ServletContextProvider";
    public static final String STRUTS_PORTLET_CONFIG_LOCATION = "StrutsPortletConfigLocation";
    public static final String PARAM_ACTION_PAGE = "ActionPage";
    public static final String PARAM_CUSTOM_PAGE = "CustomPage";
    public static final String PARAM_EDIT_PAGE = "EditPage";
    public static final String PARAM_HELP_PAGE = "HelpPage";
    public static final String PARAM_VIEW_PAGE = "ViewPage";
    private String defaultActionPage = null;
    private String defaultCustomPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;
    private String defaultViewPage = null;
    private ServletContextProvider servletContextProvider;
    private static final Log log = LogFactory.getLog((Class)StrutsPortlet.class);
    public static final String REQUEST_TYPE = "org.apache.portals.bridges.struts.request_type";
    public static final String PAGE_URL = "org.apache.portals.bridges.struts.page_url";
    public static final String ORIGIN_URL = "org.apache.portals.bridges.struts.origin_url";
    public static final String REDIRECT_PAGE_URL = "org.apache.portals.bridges.struts.redirect_page_url";
    public static final String REDIRECT_URL = "org.apache.portals.bridges.struts.redirect_url";
    public static final String RENDER_CONTEXT = "org.apache.portals.bridges.struts.render_context";
    public static final String ERROR_CONTEXT = "org.apache.portals.bridges.struts.error_context";
    public static final String PORTLET_NAME = "org.apache.portals.bridges.struts.portlet_name";
    public static final String STRUTS_PORTLET_CONFIG = "org.apache.portals.bridges.struts.portlet_config";
    public static final String DEFAULT_STRUTS_PORTLET_CONFIG_LOCATION = "WEB-INF/struts-portlet-config.xml";
    public static final String ACTION_REQUEST = "ACTION";
    public static final String VIEW_REQUEST = "VIEW";
    public static final String CUSTOM_REQUEST = "CUSTOM";
    public static final String EDIT_REQUEST = "EDIT";
    public static final String HELP_REQUEST = "HELP";
    private StrutsPortletConfig strutsPortletConfig;

    public void init(PortletConfig config) throws PortletException {
        String contextProviderClassName;
        block13: {
            super.init(config);
            contextProviderClassName = this.getContextProviderClassNameParameter(config);
            if (contextProviderClassName == null) {
                throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_SERVLET_CONTEXT_PROVIDER + " not specified");
            }
            if (contextProviderClassName != null) {
                try {
                    Object obj;
                    Class<?> clazz = Class.forName(contextProviderClassName);
                    if (clazz == null) break block13;
                    if (ServletContextProvider.class.isInstance(obj = clazz.newInstance())) {
                        this.servletContextProvider = (ServletContextProvider)obj;
                        break block13;
                    }
                    throw new PortletException("class not found");
                }
                catch (Exception e) {
                    if (e instanceof PortletException) {
                        throw (PortletException)e;
                    }
                    e.printStackTrace();
                    throw new PortletException("Cannot load", (Throwable)e);
                }
            }
        }
        if (this.servletContextProvider == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Invalid init parameter " + PARAM_SERVLET_CONTEXT_PROVIDER + " value " + contextProviderClassName);
        }
        this.defaultActionPage = this.getActionPageParameter(config);
        this.defaultCustomPage = this.getCustomPageParameter(config);
        this.defaultEditPage = this.getEditPageParameter(config);
        this.defaultViewPage = this.getViewPageParameter(config);
        this.defaultHelpPage = this.getHelpPageParameter(config);
        if (this.defaultViewPage == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (this.defaultActionPage == null) {
            this.defaultActionPage = this.defaultViewPage;
        }
        if (this.defaultCustomPage == null) {
            this.defaultCustomPage = this.defaultViewPage;
        }
        if (this.defaultHelpPage == null) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        if (this.defaultEditPage == null) {
            this.defaultEditPage = this.defaultViewPage;
        }
        this.strutsPortletConfig = new StrutsPortletConfig();
        String strutsPortletConfigLocation = this.getStrutsPortletConfigLocationParameter(config);
        if (strutsPortletConfigLocation == null) {
            strutsPortletConfigLocation = DEFAULT_STRUTS_PORTLET_CONFIG_LOCATION;
        }
        this.strutsPortletConfig.loadConfig(config.getPortletContext(), strutsPortletConfigLocation);
        config.getPortletContext().setAttribute(STRUTS_PORTLET_CONFIG, (Object)this.strutsPortletConfig);
    }

    protected String getContextProviderClassNameParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_SERVLET_CONTEXT_PROVIDER);
    }

    protected ServletContextProvider getServletContextProvider() {
        return this.servletContextProvider;
    }

    protected ServletContext getServletContext(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getServletContext(portlet);
    }

    protected HttpServletRequest getHttpServletRequest(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getHttpServletRequest(portlet, request);
    }

    protected HttpServletResponse getHttpServletResponse(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getHttpServletResponse(portlet, response);
    }

    protected String getStrutsPageURL(PortletRequest request) {
        return request.getParameter("_spage");
    }

    protected String getStrutsOriginURL(PortletRequest request) {
        return request.getParameter("_sorig");
    }

    protected String getActionPageParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_ACTION_PAGE);
    }

    protected String getCustomPageParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_CUSTOM_PAGE);
    }

    protected String getEditPageParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_EDIT_PAGE);
    }

    protected String getViewPageParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_VIEW_PAGE);
    }

    protected String getHelpPageParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_HELP_PAGE);
    }

    protected String getStrutsPortletConfigLocationParameter(PortletConfig config) {
        return config.getInitParameter(STRUTS_PORTLET_CONFIG_LOCATION);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, this.defaultEditPage, EDIT_REQUEST);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, this.defaultHelpPage, HELP_REQUEST);
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, this.defaultCustomPage, CUSTOM_REQUEST);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, this.defaultViewPage, VIEW_REQUEST);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, this.defaultActionPage, ACTION_REQUEST);
    }

    protected void processRequest(PortletRequest request, PortletResponse response, String defaultPage, String requestType) throws PortletException, IOException {
        block32: {
            ServletContext servletContext = this.getServletContext(this, request, response);
            HttpServletRequest req = this.getHttpServletRequest(this, request, response);
            Object res = this.getHttpServletResponse(this, request, response);
            HttpSession session = req.getSession();
            String portletName = this.getPortletConfig().getPortletName();
            req.setAttribute(PORTLET_NAME, (Object)portletName);
            boolean actionRequest = request instanceof ActionRequest;
            try {
                String pageURL;
                block33: {
                    RequestDispatcher rd;
                    StrutsPortletErrorContext errorContext = (StrutsPortletErrorContext)req.getSession().getAttribute("org.apache.portals.bridges.struts.error_context_" + portletName);
                    if (errorContext != null) {
                        if (!actionRequest) {
                            req.getSession().removeAttribute("org.apache.portals.bridges.struts.error_context_" + portletName);
                            this.renderError((HttpServletResponse)res, errorContext);
                        }
                        return;
                    }
                    String keepRenderAttributes = null;
                    if (!actionRequest) {
                        keepRenderAttributes = request.getParameter("_kra");
                    }
                    if (keepRenderAttributes == null) {
                        this.strutsPortletConfig.getRenderContextAttributes().clearAttributes(session);
                    } else {
                        this.strutsPortletConfig.getRenderContextAttributes().restoreAttributes(req);
                    }
                    String path = null;
                    pageURL = this.getStrutsPageURL(request);
                    path = pageURL == null ? defaultPage : pageURL;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("process path: " + path + ", requestType: " + requestType));
                    }
                    if ((rd = servletContext.getRequestDispatcher(path)) == null) break block32;
                    if (actionRequest) {
                        String origin;
                        res = new EmptyHttpServletResponseWrapper((HttpServletResponse)res);
                        if (req.getAttribute("javax.portlet.config") == null) {
                            req.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
                        }
                        if (req.getAttribute("javax.portlet.request") == null) {
                            req.setAttribute("javax.portlet.request", (Object)request);
                        }
                        if (req.getAttribute("javax.portlet.response") == null) {
                            req.setAttribute("javax.portlet.response", (Object)response);
                        }
                        if ((origin = this.getStrutsOriginURL(request)) == null) {
                            origin = defaultPage;
                        }
                        request.setAttribute(ORIGIN_URL, (Object)origin);
                    }
                    if (path != null) {
                        req.setAttribute(PAGE_URL, (Object)path);
                    }
                    req.setAttribute(REQUEST_TYPE, (Object)requestType);
                    try {
                        rd.include((ServletRequest)new PortletServletRequestWrapper(servletContext, req), (ServletResponse)res);
                    }
                    catch (ServletException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Include exception", (Throwable)e);
                        }
                        errorContext = new StrutsPortletErrorContext();
                        errorContext.setError((Exception)((Object)e));
                        req.setAttribute(ERROR_CONTEXT, (Object)errorContext);
                        if (actionRequest) break block33;
                        this.renderError((HttpServletResponse)res, errorContext);
                    }
                }
                if (actionRequest) {
                    if (req.getAttribute(ERROR_CONTEXT) != null) {
                        pageURL = StrutsPortletURL.getOriginURL((ServletRequest)req);
                        if (pageURL != null) {
                            ((ActionResponse)response).setRenderParameter("_spage", pageURL);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"action render error context");
                        }
                        try {
                            req.getSession(true).setAttribute("org.apache.portals.bridges.struts.error_context_" + portletName, req.getAttribute(ERROR_CONTEXT));
                        }
                        catch (IllegalStateException ise) {}
                    } else {
                        String renderURL = (String)req.getAttribute(REDIRECT_URL);
                        if (renderURL != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("action send redirect: " + renderURL));
                            }
                            ((ActionResponse)response).sendRedirect(renderURL);
                        } else {
                            this.strutsPortletConfig.getRenderContextAttributes().saveAttributes(req);
                            ((ActionResponse)response).setRenderParameter("_kra", "1");
                            renderURL = (String)req.getAttribute(REDIRECT_PAGE_URL);
                            if (renderURL != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("action render redirected page: " + renderURL));
                                }
                                pageURL = renderURL;
                            }
                            if (pageURL != null) {
                                if (renderURL == null && log.isWarnEnabled()) {
                                    log.warn((Object)("Warning: Using the original action URL for render URL: " + pageURL + ".\nA redirect should have been issued."));
                                }
                                ((ActionResponse)response).setRenderParameter("_spage", pageURL);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"unexpected", (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void renderError(HttpServletResponse response, StrutsPortletErrorContext errorContext) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<hr/><h2>Error</h2>");
        writer.println("<table border='1'>");
        if (errorContext.getErrorCode() != 0) {
            writer.println("<tr><td valign='top'><b>Error Code</b></td><td>" + errorContext.getErrorCode() + "</td></tr>");
        }
        if (errorContext.getErrorMessage() != null) {
            writer.println("<tr><td valign='top'><b>Error Message</b></td><td>" + errorContext.getErrorMessage() + "</td></tr>");
        }
        if (errorContext.getError() != null) {
            Throwable e = errorContext.getError();
            if (e instanceof ServletException && ((ServletException)e).getRootCause() != null) {
                e = ((ServletException)e).getRootCause();
            }
            writer.print("<tr><td valign='top'><b>Error</b></td><td>" + e.getMessage() + "</td></tr>");
            writer.print("<tr><td valign='top'><b>Error Type</b></td><td>" + e.getClass().getName() + "</td></tr>");
            writer.print("<tr><td valign='top'><b>Stacktrace</b></td><td>");
            StackTraceElement[] elements = e.getStackTrace();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < elements.length; ++i) {
                buf.append("  " + elements[i].toString() + "<br>");
            }
            writer.print(buf.toString());
            writer.println("</td></tr>");
        }
        writer.println("</table>");
    }
}

