/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.DelegatingCheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.FormattedStringFunction;
import org.gcube.io.jsonwebtoken.impl.lang.FormattedStringSupplier;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.PropagatingExceptionFunction;
import org.gcube.io.jsonwebtoken.lang.Assert;

public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T t) {
                return t;
            }
        };
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrapFmt(CheckedFunction<T, R> fn, Class<E> exClass, String msg) {
        return new PropagatingExceptionFunction<T, R, E>(fn, exClass, new FormattedStringFunction(msg));
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrap(Function<T, R> fn, Class<E> exClass, String fmt, Object ... args) {
        return new PropagatingExceptionFunction<T, R, E>(new DelegatingCheckedFunction<T, R>(fn), exClass, new FormattedStringSupplier(fmt, args));
    }

    public static <T, V, R> Function<T, R> andThen(final Function<T, ? extends V> before, final Function<V, R> after) {
        Assert.notNull(before, (String)"Before function cannot be null.");
        Assert.notNull(after, (String)"After function cannot be null.");
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                Object result = before.apply(t);
                return after.apply(result);
            }
        };
    }

    @SafeVarargs
    public static <T, R> Function<T, R> firstResult(final Function<T, R> ... fns) {
        Assert.notEmpty((Object[])fns, (String)"Function list cannot be null or empty.");
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                for (Function fn : fns) {
                    Assert.notNull((Object)fn, (String)"Function cannot be null.");
                    Object result = fn.apply(t);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

