/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.mozilla.javascript.tools.debugger;

import com.yahoo.platform.yui.mozilla.javascript.tools.debugger.SwingGui;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private Vector expressions;
    private Vector values;

    public MyTableModel(SwingGui debugGui) {
        this.debugGui = debugGui;
        this.expressions = new Vector();
        this.values = new Vector();
        this.expressions.addElement("");
        this.values.addElement("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.expressions.elementAt(row);
            }
            case 1: {
                return this.values.elementAt(row);
            }
        }
        return "";
    }

    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                String expr = value.toString();
                this.expressions.setElementAt(expr, row);
                String result = "";
                if (expr.length() > 0 && (result = this.debugGui.dim.eval(expr)) == null) {
                    result = "";
                }
                this.values.setElementAt(result, row);
                this.updateModel();
                if (row + 1 != this.expressions.size()) break;
                this.expressions.addElement("");
                this.values.addElement("");
                this.fireTableRowsInserted(row + 1, row + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Object value = this.expressions.elementAt(i);
            String expr = value.toString();
            String result = "";
            if (expr.length() > 0) {
                result = this.debugGui.dim.eval(expr);
                if (result == null) {
                    result = "";
                }
            } else {
                result = "";
            }
            result = result.replace('\n', ' ');
            this.values.setElementAt(result, i);
        }
        this.fireTableDataChanged();
    }
}

