/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import com.ecyrd.jspwiki.auth.login.WikiEngineCallback;
import com.ecyrd.jspwiki.util.HttpUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CookieAuthenticationLoginModule
extends AbstractLoginModule {
    private static final Logger log = Logger.getLogger(CookieAuthenticationLoginModule.class);
    private static final String LOGIN_COOKIE_NAME = "JSPWikiUID";
    protected static final String COOKIE_DIR = "logincookies";
    public static final String PROP_LOGIN_EXPIRY_DAYS = "jspwiki.cookieAuthentication.expiry";
    private static final int DEFAULT_EXPIRY_DAYS = 14;
    private static long c_lastScrubTime = 0L;
    private static final long SCRUB_PERIOD = 3600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        block11: {
            boolean bl;
            block12: {
                WikiEngine engine;
                File cookieFile;
                HttpRequestCallback hcb = new HttpRequestCallback();
                WikiEngineCallback wcb = new WikiEngineCallback();
                Callback[] callbacks = new Callback[]{hcb, wcb};
                this.m_handler.handle(callbacks);
                HttpServletRequest request = hcb.getRequest();
                String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
                if (uid == null || (cookieFile = CookieAuthenticationLoginModule.getCookieFile(engine = wcb.getEngine(), uid)) == null || !cookieFile.exists() || !cookieFile.canRead()) break block11;
                Reader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cookieFile), "UTF-8"));
                    String username = FileUtil.readContents(in);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Logged in cookie authenticated name=" + username));
                    }
                    this.m_principals.add(new WikiPrincipal(username, "loginName"));
                    cookieFile.setLastModified(System.currentTimeMillis());
                    bl = true;
                    if (in == null) break block12;
                }
                catch (IOException e) {
                    boolean bl2;
                    block13: {
                        try {
                            bl2 = false;
                            if (in == null) break block13;
                        }
                        catch (Throwable throwable) {
                            String message;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                            catch (IOException e2) {
                                message = "IO exception; disallowing login.";
                                log.error((Object)message, (Throwable)e2);
                                throw new LoginException(message);
                            }
                            catch (UnsupportedCallbackException e3) {
                                message = "Unable to handle callback; disallowing login.";
                                log.error((Object)message, (Throwable)e3);
                                throw new LoginException(message);
                            }
                        }
                        in.close();
                    }
                    return bl2;
                }
                in.close();
            }
            return bl;
        }
        return false;
    }

    private static File getCookieFile(WikiEngine engine, String uid) {
        File cookieDir = new File(engine.getWorkDir(), COOKIE_DIR);
        if (!cookieDir.exists()) {
            cookieDir.mkdirs();
        }
        if (!cookieDir.canRead()) {
            log.error((Object)("Cannot read from cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        if (!cookieDir.canWrite()) {
            log.error((Object)("Cannot write to cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > c_lastScrubTime + 3600000L) {
            CookieAuthenticationLoginModule.scrub(TextUtil.getIntegerProperty(engine.getWikiProperties(), PROP_LOGIN_EXPIRY_DAYS, 14), cookieDir);
            c_lastScrubTime = now;
        }
        File cookieFile = new File(cookieDir, uid);
        return cookieFile;
    }

    private static String getLoginCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue(request, LOGIN_COOKIE_NAME);
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoginCookie(WikiEngine engine, HttpServletResponse response, String username) {
        UUID uid = UUID.randomUUID();
        int days = TextUtil.getIntegerProperty(engine.getWikiProperties(), PROP_LOGIN_EXPIRY_DAYS, 14);
        Cookie userId = new Cookie(LOGIN_COOKIE_NAME, uid.toString());
        userId.setMaxAge(days * 24 * 60 * 60);
        response.addCookie(userId);
        File cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid.toString());
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cf), "UTF-8"));
            FileUtil.copyContents(new StringReader(username), out);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created login cookie for user " + username + " for " + days + " days"));
            }
        }
        catch (IOException ex) {
            log.error((Object)("Unable to create cookie file to store user id: " + uid));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log.error((Object)"Unable to close stream");
                }
            }
        }
    }

    public static void clearLoginCookie(WikiEngine engine, HttpServletRequest request, HttpServletResponse response) {
        File cf;
        Cookie userId = new Cookie(LOGIN_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
        String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
        if (uid != null && (cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid)) != null) {
            cf.delete();
        }
    }

    private static synchronized void scrub(int days, File cookieDir) {
        log.debug((Object)"Scrubbing cookieDir...");
        File[] files = cookieDir.listFiles();
        long obsoleteDateLimit = System.currentTimeMillis() - ((long)days + 1L) * 24L * 60L * 60L * 1000L;
        int deleteCount = 0;
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            long lastModified = f.lastModified();
            if (lastModified >= obsoleteDateLimit) continue;
            f.delete();
            ++deleteCount;
        }
        log.debug((Object)("Removed " + deleteCount + " obsolete cookie logins"));
    }
}

