/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.forms;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.forms.FormElement;
import com.ecyrd.jspwiki.forms.FormInfo;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.ecs.xhtml.input;

public class FormInput
extends FormElement {
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_SIZE = "size";

    public String execute(WikiContext ctx, Map params) throws PluginException {
        String inputName = (String)params.get("name");
        String inputValue = (String)params.get("value");
        String inputType = (String)params.get(PARAM_TYPE);
        String size = (String)params.get(PARAM_SIZE);
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        if (inputName == null) {
            throw new PluginException(rb.getString("forminput.namemissing"));
        }
        if (inputValue == null) {
            inputValue = "";
        }
        FormInfo info = this.getFormInfo(ctx);
        HashMap previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap();
        }
        input field = new input(inputType, "nbf_" + inputName, inputValue);
        String checked = (String)params.get("checked");
        field.setChecked(TextUtil.isPositive(checked) || "checked".equalsIgnoreCase(checked));
        String oldValue = (String)previousValues.get(inputName);
        if (oldValue != null) {
            field.setValue(oldValue);
        }
        if (size != null) {
            field.setSize(size);
        }
        return field.toString(ctx.getEngine().getContentEncoding());
    }
}

