/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.render;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventUtils;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.modules.InternalModule;
import com.ecyrd.jspwiki.parser.JSPWikiMarkupParser;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.parser.WikiDocument;
import com.ecyrd.jspwiki.render.WikiRenderer;
import com.ecyrd.jspwiki.render.XHTMLRenderer;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RenderingManager
implements WikiEventListener,
InternalModule {
    private static Logger log = Logger.getLogger(RenderingManager.class);
    private int m_cacheExpiryPeriod = 86400;
    private WikiEngine m_engine;
    public static final String PROP_CACHESIZE = "jspwiki.renderingManager.capacity";
    private static final int DEFAULT_CACHESIZE = 1000;
    private static final String VERSION_DELIMITER = "::";
    private static final String OSCACHE_ALGORITHM = "com.opensymphony.oscache.base.algorithm.LRUCache";
    private static final String PROP_RENDERER = "jspwiki.renderingManager.renderer";
    public static final String DEFAULT_RENDERER = XHTMLRenderer.class.getName();
    private Cache m_documentCache;
    private Constructor m_rendererConstructor;
    public static final String WYSIWYG_EDITOR_MODE = "WYSIWYG_EDITOR_MODE";
    public static final String VAR_EXECUTE_PLUGINS = "_PluginContent.execute";

    public void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        int cacheSize = TextUtil.getIntegerProperty(properties, PROP_CACHESIZE, -1);
        if (cacheSize == -1) {
            cacheSize = TextUtil.getIntegerProperty(properties, "jspwiki.cachingProvider.capacity", 1000);
        }
        if (cacheSize > 0) {
            this.m_documentCache = new Cache(true, false, false, false, OSCACHE_ALGORITHM, cacheSize);
        } else {
            log.info((Object)"RenderingManager caching is disabled.");
        }
        String renderImplName = properties.getProperty(PROP_RENDERER);
        if (renderImplName == null) {
            renderImplName = DEFAULT_RENDERER;
        }
        Class[] rendererParams = new Class[]{WikiContext.class, WikiDocument.class};
        try {
            Class<?> c = Class.forName(renderImplName);
            this.m_rendererConstructor = c.getConstructor(rendererParams);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to find WikiRenderer implementation " + renderImplName));
        }
        catch (SecurityException e) {
            log.error((Object)("Unable to access the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Unable to locate the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        if (this.m_rendererConstructor == null) {
            throw new WikiException("Failed to get WikiRenderer '" + renderImplName + "'.");
        }
        log.info((Object)("Rendering content with " + renderImplName + "."));
        WikiEventUtils.addWikiEventListener(this.m_engine, 21, this);
    }

    public MarkupParser getParser(WikiContext context, String pagedata) {
        JSPWikiMarkupParser parser = new JSPWikiMarkupParser(context, new StringReader(pagedata));
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WikiDocument getRenderedDocument(WikiContext context, String pagedata) throws IOException {
        boolean wasUpdated;
        String pageid;
        block12: {
            pageid = context.getRealPage().getName() + VERSION_DELIMITER + context.getRealPage().getVersion();
            wasUpdated = false;
            if (this.m_documentCache != null) {
                try {
                    WikiDocument doc = (WikiDocument)((Object)this.m_documentCache.getFromCache(pageid, this.m_cacheExpiryPeriod));
                    wasUpdated = true;
                    if (pagedata.equals(doc.getPageData())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using cached HTML for page " + pageid));
                        }
                        return doc;
                    }
                }
                catch (NeedsRefreshException e) {
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)("Re-rendering and storing " + pageid));
                }
            }
        }
        try {
            MarkupParser parser = this.getParser(context, pagedata);
            WikiDocument doc = parser.parse();
            doc.setPageData(pagedata);
            if (this.m_documentCache != null) {
                this.m_documentCache.putInCache(pageid, (Object)doc);
                wasUpdated = true;
            }
            WikiDocument wikiDocument = doc;
            return wikiDocument;
        }
        catch (IOException ex) {
            log.error((Object)"Unable to parse", (Throwable)ex);
        }
        finally {
            if (this.m_documentCache != null && !wasUpdated) {
                this.m_documentCache.cancelUpdate(pageid);
            }
        }
        return null;
    }

    public String getHTML(WikiContext context, WikiDocument doc) throws IOException {
        WikiRenderer rend = this.getRenderer(context, doc);
        return rend.getString();
    }

    public WikiRenderer getRenderer(WikiContext context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        WikiRenderer rval = null;
        try {
            rval = (WikiRenderer)this.m_rendererConstructor.newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create WikiRenderer", (Throwable)e);
        }
        return rval;
    }

    public String getHTML(WikiContext context, String pagedata) {
        try {
            WikiDocument doc = this.getRenderedDocument(context, pagedata);
            return this.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error((Object)"Unable to parse", (Throwable)e);
            return null;
        }
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiPageEvent && event.getType() == 21 && this.m_documentCache != null) {
            String pageName = ((WikiPageEvent)event).getPageName();
            this.m_documentCache.flushPattern(pageName);
            Collection referringPages = this.m_engine.getReferenceManager().findReferrers(pageName);
            if (referringPages != null) {
                for (String page : referringPages) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Flushing " + page));
                    }
                    this.m_documentCache.flushPattern(page);
                }
            }
        }
    }
}

