/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;

public class CommentedProperties
extends Properties {
    private static final long serialVersionUID = 8057284636436329669L;
    private String m_propertyString;

    public CommentedProperties() {
    }

    public CommentedProperties(Properties defaultValues) {
        super(defaultValues);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.m_propertyString = FileUtil.readContents(inStream, "ISO-8859-1");
        super.load(new ByteArrayInputStream(this.m_propertyString.getBytes("ISO-8859-1")));
    }

    public synchronized void load(Reader in) throws IOException {
        this.m_propertyString = FileUtil.readContents(in);
        super.load(new ByteArrayInputStream(this.m_propertyString.getBytes("ISO-8859-1")));
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized void store(OutputStream out, String comments) throws IOException {
        byte[] bytes = this.m_propertyString.getBytes("ISO-8859-1");
        FileUtil.copyContents(new ByteArrayInputStream(bytes), out);
        out.flush();
    }

    public synchronized Object put(Object arg0, Object arg1) {
        this.writeProperty(arg0, arg1);
        return super.put(arg0, arg1);
    }

    public synchronized void putAll(Map arg0) {
        for (Map.Entry entry : arg0.entrySet()) {
            this.writeProperty(entry.getKey(), entry.getValue());
        }
        super.putAll((Map<?, ?>)arg0);
    }

    public synchronized Object remove(Object key) {
        this.deleteProperty(key);
        return super.remove(key);
    }

    public synchronized String toString() {
        return this.m_propertyString;
    }

    private void deleteProperty(Object arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        String key = arg0.toString();
        int idx = 0;
        while (idx < this.m_propertyString.length() && (idx = this.m_propertyString.indexOf(key, idx)) != -1) {
            int prevret = this.m_propertyString.lastIndexOf("\n", idx);
            if (prevret != -1 && this.m_propertyString.charAt(prevret + 1) == '#') {
                idx += key.length();
                continue;
            }
            int eqsign = this.m_propertyString.indexOf("=", idx);
            if (eqsign == -1) continue;
            int ret = this.m_propertyString.indexOf("\n", eqsign);
            this.m_propertyString = TextUtil.replaceString(this.m_propertyString, prevret, ret, "");
            return;
        }
    }

    private void writeProperty(Object arg0, Object arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (arg1 == null) {
            arg1 = "";
        }
        String key = arg0.toString();
        String value = TextUtil.native2Ascii(arg1.toString());
        int idx = 0;
        while (idx < this.m_propertyString.length() && (idx = this.m_propertyString.indexOf(key, idx)) != -1) {
            int prevret = this.m_propertyString.lastIndexOf("\n", idx);
            if (prevret != -1 && this.m_propertyString.charAt(prevret + 1) == '#') {
                idx += key.length();
                continue;
            }
            int eqsign = this.m_propertyString.indexOf("=", idx);
            if (eqsign == -1) continue;
            int ret = this.m_propertyString.indexOf("\n", eqsign);
            if (ret == -1) {
                ret = this.m_propertyString.length();
            }
            this.m_propertyString = TextUtil.replaceString(this.m_propertyString, eqsign + 1, ret, value);
            return;
        }
        this.m_propertyString = this.m_propertyString + "\n" + key + " = " + value + "\n";
    }
}

