/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.comparators.JavaNaturalComparator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSorter
implements Comparator {
    private static Logger log = Logger.getLogger(PageSorter.class);
    protected static final String PROP_PAGE_NAME_COMPARATOR = "jspwiki.pageNameComparator.class";
    private Comparator<String> m_comparator;

    public PageSorter() {
        this.m_comparator = JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR;
    }

    public PageSorter(Comparator<String> comparator) {
        this.m_comparator = comparator;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof String) {
            if (o2 instanceof String) {
                return this.m_comparator.compare((String)o1, (String)o2);
            }
            if (o2 instanceof WikiPage) {
                return this.m_comparator.compare((String)o1, ((WikiPage)o2).getName());
            }
        } else if (o1 instanceof WikiPage) {
            if (o2 instanceof WikiPage) {
                return this.m_comparator.compare(((WikiPage)o1).getName(), ((WikiPage)o2).getName());
            }
            if (o2 instanceof String) {
                return this.m_comparator.compare(((WikiPage)o1).getName(), (String)o2);
            }
        }
        throw new IllegalArgumentException("Can only compare String or WikiPage");
    }

    public int compare(String pageName1, String pageName2) {
        return this.m_comparator.compare(pageName1, pageName2);
    }

    public int compare(WikiPage page1, WikiPage page2) {
        if (page1 == page2) {
            return 0;
        }
        int res = this.m_comparator.compare(page1.getName(), page2.getName());
        if (res == 0) {
            res = page1.getVersion() - page2.getVersion();
        }
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PageSorter)) {
            return false;
        }
        PageSorter that = (PageSorter)o;
        if (this == that || this.m_comparator == that.m_comparator) {
            return true;
        }
        return ((Object)this.m_comparator).equals(that.m_comparator);
    }

    public void initialize(Properties props) {
        this.m_comparator = JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR;
        String className = props.getProperty(PROP_PAGE_NAME_COMPARATOR);
        if (className != null && className.length() > 0) {
            try {
                this.m_comparator = (Comparator)ClassUtil.findClass("com.ecyrd.jspwiki.util.comparators", className).newInstance();
            }
            catch (Exception e) {
                log.error((Object)"Falling back to default \"natural\" comparator", (Throwable)e);
            }
        }
    }

    public void sort(List<String> nameList) {
        Collections.sort(nameList, this.m_comparator);
    }

    public void sort(String[] nameArray) {
        Arrays.sort(nameArray, this.m_comparator);
    }

    public void sortPages(List<Object> pageList) {
        Collections.sort(pageList, this);
    }

    public void sortPages(Object[] pageArray) {
        Arrays.sort(pageArray, this);
    }
}

