/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.net.URL;
import org.gcube.event.publisher.AbstractHTTPWithJWTTokenAuthEventSender;
import org.gcube.event.publisher.EventSender;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;

public class HTTPWithOIDCAuthEventSender
extends AbstractHTTPWithJWTTokenAuthEventSender
implements EventSender {
    public HTTPWithOIDCAuthEventSender(URL baseEndpointURL, String clientId, String clientSecret, URL tokenURL) {
        super(baseEndpointURL, clientId, clientSecret, tokenURL);
    }

    @Override
    protected JWTToken getAuthorizationToken() throws OpenIdConnectRESTHelperException {
        if (this.clientId != null && this.clientSecret != null && this.tokenURL != null) {
            log.debug("Getting OIDC token for clientId '{}' from: {}", (Object)this.clientId, (Object)this.tokenURL);
            return OpenIdConnectRESTHelper.queryClientToken((String)this.clientId, (String)this.clientSecret, (URL)this.tokenURL);
        }
        log.debug("Can't get OIDC token since not all the required params were provied");
        return null;
    }
}

