/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.security;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.QueryString;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSecurityManager {
    private static Logger logger = LoggerFactory.getLogger(PortalSecurityManager.class);
    String scope;

    public PortalSecurityManager(String scope) {
        this.scope = scope;
    }

    public PortalSecurityManager(ASLSession session) {
        this.scope = session.getScope();
    }

    public boolean isSecurityEnabled() {
        QueryString query = new QueryString();
        query.put("vreResource", "true");
        query.put("vre", this.scope.toString());
        List res = (List)((Object)CachesManager.getInstance().getGenericResourceCache().get((Serializable)query).getValue());
        if (res == null || res.size() == 0) {
            return false;
        }
        try {
            return this.parseBody(((ISGenericResource)res.get(0)).getBody());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    private boolean parseBody(String body) throws Exception {
        block8: {
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new BufferedReader(new StringReader(body)));
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("SecurityEnabled")) {
                                boolean res = Boolean.valueOf(parser.nextText());
                                logger.debug("Found value:" + res);
                                return res;
                            }
                            parser.nextText();
                            break;
                        }
                        case 1: {
                            break block8;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new Exception("Unable to parse the ScopeResource body");
            }
        }
        return false;
    }
}

