/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.session;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    protected static Thread thread = new CleanSessionThread();
    protected static SessionManager sessionManager = new SessionManager();
    protected HashMap<String, ASLSession> sessions = new HashMap();

    protected SessionManager() {
        thread.setDaemon(true);
        thread.start();
    }

    public static SessionManager getInstance() {
        return sessionManager;
    }

    public ASLSession getASLSession(String externalSessionID, String username) {
        ASLSession session = this.sessions.get(externalSessionID + "_" + username);
        if (session == null || !session.isValid() || !session.getUsername().equals(username)) {
            session = new ASLSession(externalSessionID, username);
            this.sessions.put(externalSessionID + "_" + username, session);
        }
        if (session.getScope() != null) {
            ScopeProvider.instance.set(session.getScopeName());
        }
        if (session.getSecurityToken() != null) {
            logger.debug("Setting SecurityTokenProvider to: " + session.getSecurityToken() + " in thread " + Thread.currentThread().getId());
            SecurityTokenProvider.instance.set(session.getSecurityToken());
        }
        return session;
    }

    protected void finalize() throws Throwable {
        thread.interrupt();
        logger.debug(new Date(System.currentTimeMillis()) + " clean thread was interrupted");
        thread.join();
        logger.debug(new Date(System.currentTimeMillis()) + " clean thread was joint");
        super.finalize();
    }

    protected static class CleanSessionThread
    extends Thread {
        protected CleanSessionThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception:", (Throwable)e);
                    logger.debug(new Date(System.currentTimeMillis()) + " clean thread was interrupted (in clean thread)");
                    break;
                }
                Set<String> keys = SessionManager.sessionManager.sessions.keySet();
                Iterator<String> iter = keys.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    String extSessionID = iter.next();
                    if (SessionManager.sessionManager.sessions.get(extSessionID).isValid()) continue;
                    SessionManager.sessionManager.sessions.remove(extSessionID);
                }
                break;
            }
            logger.debug(new Date(System.currentTimeMillis()) + " clean thread was terminated");
        }
    }
}

