/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.SingleValueGenerator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.util.Arrays;

final class Generators {
    private static final int MAX_YEARS_BETWEEN_INSTANCES = 100;

    static ThrottledGenerator serialYearGenerator(final int interval, DateValue dtStart) {
        return new ThrottledGenerator(dtStart){
            int year;
            int throttle;
            {
                this.year = dateValue.year() - n;
                this.throttle = 100;
            }

            @Override
            boolean generate(DTBuilder builder) throws Generator.IteratorShortCircuitingException {
                if (--this.throttle < 0) {
                    throw Generator.IteratorShortCircuitingException.instance();
                }
                builder.year = this.year += interval;
                return true;
            }

            @Override
            void workDone() {
                this.throttle = 100;
            }

            public String toString() {
                return "serialYearGenerator:" + interval;
            }
        };
    }

    static Generator serialMonthGenerator(final int interval, DateValue dtStart) {
        return new Generator(dtStart){
            int year;
            int month;
            {
                this.year = dateValue.year();
                this.month = dateValue.month() - n;
                while (this.month < 1) {
                    this.month += 12;
                    --this.year;
                }
            }

            @Override
            boolean generate(DTBuilder builder) {
                int nmonth;
                if (this.year != builder.year) {
                    int monthsBetween = (builder.year - this.year) * 12 - (this.month - 1);
                    nmonth = (interval - monthsBetween % interval) % interval + 1;
                    if (nmonth > 12) {
                        return false;
                    }
                    this.year = builder.year;
                } else {
                    nmonth = this.month + interval;
                    if (nmonth > 12) {
                        return false;
                    }
                }
                this.month = builder.month = nmonth;
                return true;
            }

            public String toString() {
                return "serialMonthGenerator:" + interval;
            }
        };
    }

    static Generator serialDayGenerator(final int interval, DateValue dtStart) {
        return new Generator(dtStart){
            int year;
            int month;
            int date;
            int nDays;
            {
                DTBuilder dtStartMinus1B = new DTBuilder(dateValue);
                dtStartMinus1B.day -= n;
                DateValue dtStartMinus1 = dtStartMinus1B.toDate();
                this.year = dtStartMinus1.year();
                this.month = dtStartMinus1.month();
                this.date = dtStartMinus1.day();
                this.nDays = TimeUtils.monthLength(this.year, this.month);
            }

            @Override
            boolean generate(DTBuilder builder) {
                int ndate;
                if (this.year == builder.year && this.month == builder.month) {
                    ndate = this.date + interval;
                    if (ndate > this.nDays) {
                        return false;
                    }
                } else {
                    this.nDays = TimeUtils.monthLength(builder.year, builder.month);
                    if (interval != 1) {
                        int daysBetween = TimeUtils.daysBetween(new DateValueImpl(builder.year, builder.month, 1), new DateValueImpl(this.year, this.month, this.date));
                        ndate = (interval - daysBetween % interval) % interval + 1;
                        if (ndate > this.nDays) {
                            return false;
                        }
                    } else {
                        ndate = 1;
                    }
                    this.year = builder.year;
                    this.month = builder.month;
                }
                this.date = builder.day = ndate;
                return true;
            }

            public String toString() {
                return "serialDayGenerator:" + interval;
            }
        };
    }

    static Generator serialHourGenerator(final int interval, DateValue dtStart) {
        return new Generator(dtStart){
            int hour;
            int day;
            int month;
            int year;
            {
                this.hour = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0) - n;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder builder) {
                int nhour;
                if (this.day != builder.day || this.month != builder.month || this.year != builder.year) {
                    int hoursBetween = Generators.daysBetween(builder, this.year, this.month, this.day) * 24 - this.hour;
                    nhour = (interval - hoursBetween % interval) % interval;
                    if (nhour > 23) {
                        return false;
                    }
                    this.day = builder.day;
                    this.month = builder.month;
                    this.year = builder.year;
                } else {
                    nhour = this.hour + interval;
                    if (nhour > 23) {
                        return false;
                    }
                }
                this.hour = builder.hour = nhour;
                return true;
            }

            public String toString() {
                return "serialHourGenerator:" + interval;
            }
        };
    }

    static Generator serialMinuteGenerator(final int interval, DateValue dtStart) {
        return new Generator(dtStart){
            int minute;
            int hour;
            int day;
            int month;
            int year;
            {
                this.minute = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0) - n;
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder builder) {
                int nminute;
                if (this.hour != builder.hour || this.day != builder.day || this.month != builder.month || this.year != builder.year) {
                    int minutesBetween = (Generators.daysBetween(builder, this.year, this.month, this.day) * 24 + builder.hour - this.hour) * 60 - this.minute;
                    nminute = (interval - minutesBetween % interval) % interval;
                    if (nminute > 59) {
                        return false;
                    }
                    this.hour = builder.hour;
                    this.day = builder.day;
                    this.month = builder.month;
                    this.year = builder.year;
                } else {
                    nminute = this.minute + interval;
                    if (nminute > 59) {
                        return false;
                    }
                }
                this.minute = builder.minute = nminute;
                return true;
            }

            public String toString() {
                return "serialMinuteGenerator:" + interval;
            }
        };
    }

    static Generator serialSecondGenerator(final int interval, DateValue dtStart) {
        return new Generator(dtStart){
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            {
                this.second = (dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).second() : 0) - n;
                this.minute = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.day = dateValue.day();
                this.month = dateValue.month();
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder builder) {
                int nsecond;
                if (this.minute != builder.minute || this.hour != builder.hour || this.day != builder.day || this.month != builder.month || this.year != builder.year) {
                    int secondsBetween = ((Generators.daysBetween(builder, this.year, this.month, this.day) * 24 + builder.hour - this.hour) * 60 + builder.minute - this.minute) * 60 - this.second;
                    nsecond = (interval - secondsBetween % interval) % interval;
                    if (nsecond > 59) {
                        return false;
                    }
                    this.minute = builder.minute;
                    this.hour = builder.hour;
                    this.day = builder.day;
                    this.month = builder.month;
                    this.year = builder.year;
                } else {
                    nsecond = this.second + interval;
                    if (nsecond > 59) {
                        return false;
                    }
                }
                this.second = builder.second = nsecond;
                return true;
            }

            public String toString() {
                return "serialSecondGenerator:" + interval;
            }
        };
    }

    static Generator byYearGenerator(int[] years, DateValue dtStart) {
        final int[] uyears = Util.uniquify(years);
        return new Generator(dtStart){
            int i;
            {
                while (this.i < nArray.length && dateValue.year() > nArray[this.i]) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.i >= uyears.length) {
                    return false;
                }
                builder.year = uyears[this.i++];
                return true;
            }

            public String toString() {
                return "byYearGenerator";
            }
        };
    }

    static Generator byMonthGenerator(int[] months, DateValue dtStart) {
        final int[] umonths = Util.uniquify(months);
        return new Generator(dtStart){
            int i;
            int year;
            {
                this.year = dateValue.year();
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year) {
                    this.i = 0;
                    this.year = builder.year;
                }
                if (this.i >= umonths.length) {
                    return false;
                }
                builder.month = umonths[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthGenerator:" + Arrays.toString(umonths);
            }
        };
    }

    static Generator byHourGenerator(int[] hours, DateValue dtStart) {
        int[] uhours;
        int startHour = dtStart instanceof TimeValue ? ((TimeValue)((Object)dtStart)).hour() : 0;
        if ((hours = Util.uniquify(hours)).length == 0) {
            hours = new int[]{startHour};
        }
        if ((uhours = hours).length == 1) {
            final int hour = uhours[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;

                @Override
                boolean generate(DTBuilder builder) {
                    if (this.year != builder.year || this.month != builder.month || this.day != builder.day) {
                        this.year = builder.year;
                        this.month = builder.month;
                        this.day = builder.day;
                        builder.hour = hour;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return hour;
                }

                public String toString() {
                    return "byHourGenerator:" + hour;
                }
            };
        }
        return new Generator(dtStart){
            int i;
            int year;
            int month;
            int day;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                int hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                while (this.i < nArray.length && nArray[this.i] < hour) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month || this.day != builder.day) {
                    this.i = 0;
                    this.year = builder.year;
                    this.month = builder.month;
                    this.day = builder.day;
                }
                if (this.i >= uhours.length) {
                    return false;
                }
                builder.hour = uhours[this.i++];
                return true;
            }

            public String toString() {
                return "byHourGenerator:" + Arrays.toString(uhours);
            }
        };
    }

    static Generator byMinuteGenerator(int[] minutes, DateValue dtStart) {
        int[] uminutes;
        if ((minutes = Util.uniquify(minutes)).length == 0) {
            minutes = new int[]{dtStart instanceof TimeValue ? ((TimeValue)((Object)dtStart)).minute() : 0};
        }
        if ((uminutes = minutes).length == 1) {
            final int minute = uminutes[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;
                int hour;

                @Override
                boolean generate(DTBuilder builder) {
                    if (this.year != builder.year || this.month != builder.month || this.day != builder.day || this.hour != builder.hour) {
                        this.year = builder.year;
                        this.month = builder.month;
                        this.day = builder.day;
                        this.hour = builder.hour;
                        builder.minute = minute;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return minute;
                }

                public String toString() {
                    return "byMinuteGenerator:" + minute;
                }
            };
        }
        return new Generator(dtStart){
            int i;
            int year;
            int month;
            int day;
            int hour;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                int minute = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                while (this.i < nArray.length && nArray[this.i] < minute) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month || this.day != builder.day || this.hour != builder.hour) {
                    this.i = 0;
                    this.year = builder.year;
                    this.month = builder.month;
                    this.day = builder.day;
                    this.hour = builder.hour;
                }
                if (this.i >= uminutes.length) {
                    return false;
                }
                builder.minute = uminutes[this.i++];
                return true;
            }

            public String toString() {
                return "byMinuteGenerator:" + Arrays.toString(uminutes);
            }
        };
    }

    static Generator bySecondGenerator(int[] seconds, DateValue dtStart) {
        int[] useconds;
        if ((seconds = Util.uniquify(seconds)).length == 0) {
            seconds = new int[]{dtStart instanceof TimeValue ? ((TimeValue)((Object)dtStart)).second() : 0};
        }
        if ((useconds = seconds).length == 1) {
            final int second = useconds[0];
            return new SingleValueGenerator(){
                int year;
                int month;
                int day;
                int hour;
                int minute;

                @Override
                boolean generate(DTBuilder builder) {
                    if (this.year != builder.year || this.month != builder.month || this.day != builder.day || this.hour != builder.hour || this.minute != builder.minute) {
                        this.year = builder.year;
                        this.month = builder.month;
                        this.day = builder.day;
                        this.hour = builder.hour;
                        this.minute = builder.minute;
                        builder.second = second;
                        return true;
                    }
                    return false;
                }

                @Override
                int getValue() {
                    return second;
                }

                public String toString() {
                    return "bySecondGenerator:" + second;
                }
            };
        }
        return new Generator(dtStart){
            int i;
            int year;
            int month;
            int day;
            int hour;
            int minute;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.day = dateValue.day();
                this.hour = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).hour() : 0;
                this.minute = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).minute() : 0;
                int second = dateValue instanceof TimeValue ? ((TimeValue)((Object)dateValue)).second() : 0;
                while (this.i < nArray.length && nArray[this.i] < second) {
                    ++this.i;
                }
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month || this.day != builder.day || this.hour != builder.hour || this.minute != builder.minute) {
                    this.i = 0;
                    this.year = builder.year;
                    this.month = builder.month;
                    this.day = builder.day;
                    this.hour = builder.hour;
                    this.minute = builder.minute;
                }
                if (this.i >= useconds.length) {
                    return false;
                }
                builder.second = useconds[this.i++];
                return true;
            }

            public String toString() {
                return "bySecondGenerator:" + Arrays.toString(useconds);
            }
        };
    }

    static Generator byMonthDayGenerator(int[] dates, DateValue dtStart) {
        final int[] udates = Util.uniquify(dates);
        return new Generator(dtStart){
            int year;
            int month;
            int[] posDates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.convertDatesToAbsolute();
            }

            private void convertDatesToAbsolute() {
                IntSet posDates = new IntSet();
                int nDays = TimeUtils.monthLength(this.year, this.month);
                int j = 0;
                while (j < udates.length) {
                    int date = udates[j];
                    if (date < 0) {
                        date += nDays + 1;
                    }
                    if (date >= 1 && date <= nDays) {
                        posDates.add(date);
                    }
                    ++j;
                }
                this.posDates = posDates.toIntArray();
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.convertDatesToAbsolute();
                    this.i = 0;
                }
                if (this.i >= this.posDates.length) {
                    return false;
                }
                builder.day = this.posDates[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthDayGenerator";
            }
        };
    }

    static Generator byDayGenerator(WeekdayNum[] days, final boolean weeksInYear, DateValue dtStart) {
        final WeekdayNum[] udays = (WeekdayNum[])days.clone();
        return new Generator(dtStart){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.generateDates();
                int day = dateValue.day();
                while (this.i < this.dates.length && this.dates[this.i] < day) {
                    ++this.i;
                }
            }

            void generateDates() {
                int d0;
                Weekday dow0;
                int nDays;
                int nDaysInMonth = TimeUtils.monthLength(this.year, this.month);
                if (weeksInYear) {
                    nDays = TimeUtils.yearLength(this.year);
                    dow0 = Weekday.firstDayOfWeekInMonth(this.year, 1);
                    d0 = TimeUtils.dayOfYear(this.year, this.month, 1);
                } else {
                    nDays = nDaysInMonth;
                    dow0 = Weekday.firstDayOfWeekInMonth(this.year, this.month);
                    d0 = 0;
                }
                int w0 = d0 / 7;
                IntSet udates = new IntSet();
                int j = 0;
                while (j < udays.length) {
                    WeekdayNum day = udays[j];
                    if (day.num != 0) {
                        int date = Util.dayNumToDate(dow0, nDays, day.num, day.wday, d0, nDaysInMonth);
                        if (date != 0) {
                            udates.add(date);
                        }
                    } else {
                        int wn = w0 + 6;
                        int w = w0;
                        while (w <= wn) {
                            int date = Util.dayNumToDate(dow0, nDays, w, day.wday, d0, nDaysInMonth);
                            if (date != 0) {
                                udates.add(date);
                            }
                            ++w;
                        }
                    }
                    ++j;
                }
                this.dates = udates.toIntArray();
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.generateDates();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byDayGenerator:" + Arrays.toString(udays) + " by " + (weeksInYear ? "year" : "week");
            }
        };
    }

    static Generator byWeekNoGenerator(int[] weekNos, final Weekday wkst, DateValue dtStart) {
        final int[] uWeekNos = Util.uniquify(weekNos);
        return new Generator(dtStart){
            int year;
            int month;
            int weeksInYear;
            int[] dates;
            int i;
            int doyOfStartOfWeek1;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.checkYear();
                this.checkMonth();
            }

            void checkYear() {
                Weekday dowJan1 = Weekday.firstDayOfWeekInMonth(this.year, 1);
                int nDaysInFirstWeek = 7 - (7 + dowJan1.javaDayNum - wkst.javaDayNum) % 7;
                int nOrphanedDays = 0;
                if (nDaysInFirstWeek < 4) {
                    nOrphanedDays = nDaysInFirstWeek;
                    nDaysInFirstWeek = 7;
                }
                this.doyOfStartOfWeek1 = nDaysInFirstWeek - 7 + nOrphanedDays;
                this.weeksInYear = (TimeUtils.yearLength(this.year) - nOrphanedDays + 6) / 7;
            }

            void checkMonth() {
                int doyOfMonth1 = TimeUtils.dayOfYear(this.year, this.month, 1);
                int weekOfMonth = (doyOfMonth1 - this.doyOfStartOfWeek1) / 7 + 1;
                int nDays = TimeUtils.monthLength(this.year, this.month);
                IntSet udates = new IntSet();
                int j = 0;
                while (j < uWeekNos.length) {
                    int weekNo = uWeekNos[j];
                    if (weekNo < 0) {
                        weekNo += this.weeksInYear + 1;
                    }
                    if (weekNo >= weekOfMonth - 1 && weekNo <= weekOfMonth + 6) {
                        int d = 0;
                        while (d < 7) {
                            int date = (weekNo - 1) * 7 + d + this.doyOfStartOfWeek1 - doyOfMonth1 + 1;
                            if (date >= 1 && date <= nDays) {
                                udates.add(date);
                            }
                            ++d;
                        }
                    }
                    ++j;
                }
                this.dates = udates.toIntArray();
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    if (this.year != builder.year) {
                        this.year = builder.year;
                        this.checkYear();
                    }
                    this.month = builder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byWeekNoGenerator";
            }
        };
    }

    static Generator byYearDayGenerator(int[] yearDays, DateValue dtStart) {
        final int[] uYearDays = Util.uniquify(yearDays);
        return new Generator(dtStart){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dateValue.year();
                this.month = dateValue.month();
                this.i = 0;
                this.checkMonth();
            }

            void checkMonth() {
                int doyOfMonth1 = TimeUtils.dayOfYear(this.year, this.month, 1);
                int nDays = TimeUtils.monthLength(this.year, this.month);
                int nYearDays = TimeUtils.yearLength(this.year);
                IntSet udates = new IntSet();
                int j = 0;
                while (j < uYearDays.length) {
                    int date;
                    int yearDay = uYearDays[j];
                    if (yearDay < 0) {
                        yearDay += nYearDays + 1;
                    }
                    if ((date = yearDay - doyOfMonth1) >= 1 && date <= nDays) {
                        udates.add(date);
                    }
                    ++j;
                }
                this.dates = udates.toIntArray();
            }

            @Override
            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byYearDayGenerator";
            }
        };
    }

    private static int daysBetween(DTBuilder builder, int year, int month, int day) {
        if (year == builder.year && month == builder.month) {
            return builder.day - day;
        }
        return TimeUtils.daysBetween(builder.year, builder.month, builder.day, year, month, day);
    }

    private Generators() {
    }
}

