/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.segmentation.CompositeBreakIterator;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.analysis.icu.tokenattributes.ScriptAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class ICUTokenizer
extends Tokenizer {
    private static final int IOBUFFER = 4096;
    private final char[] buffer = new char[4096];
    private int length = 0;
    private int usableLength = 0;
    private int offset = 0;
    private final CompositeBreakIterator breaker;
    private final ICUTokenizerConfig config;
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final ScriptAttribute scriptAtt = (ScriptAttribute)this.addAttribute(ScriptAttribute.class);

    public ICUTokenizer(Reader input) {
        this(input, new DefaultICUTokenizerConfig());
    }

    public ICUTokenizer(Reader input, ICUTokenizerConfig config) {
        super(input);
        this.config = config;
        this.breaker = new CompositeBreakIterator(config);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.length == 0) {
            this.refill();
        }
        while (!this.incrementTokenBuffer()) {
            this.refill();
            if (this.length > 0) continue;
            return false;
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.breaker.setText(this.buffer, 0, 0);
        this.offset = 0;
        this.usableLength = 0;
        this.length = 0;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }

    public void end() throws IOException {
        int finalOffset = this.length < 0 ? this.offset : this.offset + this.length;
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    private int findSafeEnd() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!UCharacter.isWhitespace((int)this.buffer[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private void refill() throws IOException {
        this.offset += this.usableLength;
        int leftover = this.length - this.usableLength;
        System.arraycopy(this.buffer, this.usableLength, this.buffer, 0, leftover);
        int requested = this.buffer.length - leftover;
        int returned = this.input.read(this.buffer, leftover, requested);
        int n = this.length = returned < 0 ? leftover : returned + leftover;
        if (returned < requested) {
            this.usableLength = this.length;
        } else {
            this.usableLength = this.findSafeEnd();
            if (this.usableLength < 0) {
                this.usableLength = this.length;
            }
        }
        this.breaker.setText(this.buffer, 0, Math.max(0, this.usableLength));
    }

    private boolean incrementTokenBuffer() {
        int start = this.breaker.current();
        if (start == -1) {
            return false;
        }
        int end = this.breaker.next();
        while (start != -1 && this.breaker.getRuleStatus() == 0) {
            start = end;
            end = this.breaker.next();
        }
        if (start == -1) {
            return false;
        }
        this.termAtt.copyBuffer(this.buffer, start, end - start);
        this.offsetAtt.setOffset(this.correctOffset(this.offset + start), this.correctOffset(this.offset + end));
        this.typeAtt.setType(this.config.getType(this.breaker.getScriptCode(), this.breaker.getRuleStatus()));
        this.scriptAtt.setCode(this.breaker.getScriptCode());
        return true;
    }
}

