/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service;

import com.liferay.oauth.NoSuchApplicationException;
import com.liferay.oauth.NoSuchUserException;
import com.liferay.oauth.OAuthApplicationCallbackURIException;
import com.liferay.oauth.OAuthApplicationNameException;
import com.liferay.oauth.OAuthApplicationWebsiteURLException;
import com.liferay.oauth.model.OAuthApplicationClp;
import com.liferay.oauth.model.OAuthUserClp;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClpSerializer {
    private static Log _log = LogFactoryUtil.getLog(ClpSerializer.class);
    private static String _servletContextName;
    private static boolean _useReflectionToTranslateThrowable;

    static {
        _useReflectionToTranslateThrowable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServletContextName() {
        if (Validator.isNotNull((String)_servletContextName)) {
            return _servletContextName;
        }
        Class<ClpSerializer> clazz = ClpSerializer.class;
        synchronized (ClpSerializer.class) {
            block14: {
                block13: {
                    if (Validator.isNotNull((String)_servletContextName)) {
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return _servletContextName;
                    }
                    try {
                        ClassLoader classLoader = ClpSerializer.class.getClassLoader();
                        Class<?> portletPropsClass = classLoader.loadClass("com.liferay.util.portlet.PortletProps");
                        Method getMethod = portletPropsClass.getMethod("get", String.class);
                        String portletPropsServletContextName = (String)getMethod.invoke(null, "oauth-portlet-deployment-context");
                        if (Validator.isNotNull((String)portletPropsServletContextName)) {
                            _servletContextName = portletPropsServletContextName;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_log.isInfoEnabled()) break block13;
                        _log.info((Object)"Unable to locate deployment context from portlet properties");
                    }
                }
                if (Validator.isNull((String)_servletContextName)) {
                    try {
                        String propsUtilServletContextName = PropsUtil.get((String)"oauth-portlet-deployment-context");
                        if (Validator.isNotNull((String)propsUtilServletContextName)) {
                            _servletContextName = propsUtilServletContextName;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_log.isInfoEnabled()) break block14;
                        _log.info((Object)"Unable to locate deployment context from portal properties");
                    }
                }
            }
            if (Validator.isNull((String)_servletContextName)) {
                _servletContextName = "oauth-portlet";
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _servletContextName;
        }
    }

    public static Object translateInput(BaseModel<?> oldModel) {
        Class<?> oldModelClass = oldModel.getClass();
        String oldModelClassName = oldModelClass.getName();
        if (oldModelClassName.equals(OAuthApplicationClp.class.getName())) {
            return ClpSerializer.translateInputOAuthApplication(oldModel);
        }
        if (oldModelClassName.equals(OAuthUserClp.class.getName())) {
            return ClpSerializer.translateInputOAuthUser(oldModel);
        }
        return oldModel;
    }

    public static Object translateInput(List<Object> oldList) {
        ArrayList<Object> newList = new ArrayList<Object>(oldList.size());
        int i = 0;
        while (i < oldList.size()) {
            Object curObj = oldList.get(i);
            newList.add(ClpSerializer.translateInput(curObj));
            ++i;
        }
        return newList;
    }

    public static Object translateInputOAuthApplication(BaseModel<?> oldModel) {
        OAuthApplicationClp oldClpModel = (OAuthApplicationClp)oldModel;
        BaseModel<?> newModel = oldClpModel.getOAuthApplicationRemoteModel();
        newModel.setModelAttributes(oldClpModel.getModelAttributes());
        return newModel;
    }

    public static Object translateInputOAuthUser(BaseModel<?> oldModel) {
        OAuthUserClp oldClpModel = (OAuthUserClp)oldModel;
        BaseModel<?> newModel = oldClpModel.getOAuthUserRemoteModel();
        newModel.setModelAttributes(oldClpModel.getModelAttributes());
        return newModel;
    }

    public static Object translateInput(Object obj) {
        if (obj instanceof BaseModel) {
            return ClpSerializer.translateInput((BaseModel)obj);
        }
        if (obj instanceof List) {
            return ClpSerializer.translateInput((List)obj);
        }
        return obj;
    }

    public static Object translateOutput(BaseModel<?> oldModel) {
        block9: {
            String oldModelClassName;
            Class<?> oldModelClass;
            block8: {
                oldModelClass = oldModel.getClass();
                oldModelClassName = oldModelClass.getName();
                if (oldModelClassName.equals("com.liferay.oauth.model.impl.OAuthApplicationImpl")) {
                    return ClpSerializer.translateOutputOAuthApplication(oldModel);
                }
                if (oldModelClassName.endsWith("Clp")) {
                    try {
                        ClassLoader classLoader = ClpSerializer.class.getClassLoader();
                        Method getClpSerializerClassMethod = oldModelClass.getMethod("getClpSerializerClass", new Class[0]);
                        Class oldClpSerializerClass = (Class)getClpSerializerClassMethod.invoke(oldModel, new Object[0]);
                        Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());
                        Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput", BaseModel.class);
                        Class oldModelModelClass = oldModel.getModelClass();
                        Method getRemoteModelMethod = oldModelClass.getMethod("get" + oldModelModelClass.getSimpleName() + "RemoteModel", new Class[0]);
                        Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel, new Object[0]);
                        BaseModel newModel = (BaseModel)translateOutputMethod.invoke(null, oldRemoteModel);
                        return newModel;
                    }
                    catch (Throwable t) {
                        if (!_log.isInfoEnabled()) break block8;
                        _log.info((Object)("Unable to translate " + oldModelClassName), t);
                    }
                }
            }
            if (oldModelClassName.equals("com.liferay.oauth.model.impl.OAuthUserImpl")) {
                return ClpSerializer.translateOutputOAuthUser(oldModel);
            }
            if (oldModelClassName.endsWith("Clp")) {
                try {
                    ClassLoader classLoader = ClpSerializer.class.getClassLoader();
                    Method getClpSerializerClassMethod = oldModelClass.getMethod("getClpSerializerClass", new Class[0]);
                    Class oldClpSerializerClass = (Class)getClpSerializerClassMethod.invoke(oldModel, new Object[0]);
                    Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());
                    Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput", BaseModel.class);
                    Class oldModelModelClass = oldModel.getModelClass();
                    Method getRemoteModelMethod = oldModelClass.getMethod("get" + oldModelModelClass.getSimpleName() + "RemoteModel", new Class[0]);
                    Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel, new Object[0]);
                    BaseModel newModel = (BaseModel)translateOutputMethod.invoke(null, oldRemoteModel);
                    return newModel;
                }
                catch (Throwable t) {
                    if (!_log.isInfoEnabled()) break block9;
                    _log.info((Object)("Unable to translate " + oldModelClassName), t);
                }
            }
        }
        return oldModel;
    }

    public static Object translateOutput(List<Object> oldList) {
        ArrayList<Object> newList = new ArrayList<Object>(oldList.size());
        int i = 0;
        while (i < oldList.size()) {
            Object curObj = oldList.get(i);
            newList.add(ClpSerializer.translateOutput(curObj));
            ++i;
        }
        return newList;
    }

    public static Object translateOutput(Object obj) {
        if (obj instanceof BaseModel) {
            return ClpSerializer.translateOutput((BaseModel)obj);
        }
        if (obj instanceof List) {
            return ClpSerializer.translateOutput((List)obj);
        }
        return obj;
    }

    public static Throwable translateThrowable(Throwable throwable) {
        Class<?> clazz;
        String className;
        if (_useReflectionToTranslateThrowable) {
            try {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
                objectOutputStream.writeObject(throwable);
                objectOutputStream.flush();
                objectOutputStream.close();
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream((InputStream)unsyncByteArrayInputStream, contextClassLoader);
                throwable = (Throwable)objectInputStream.readObject();
                objectInputStream.close();
                return throwable;
            }
            catch (SecurityException securityException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Do not use reflection to translate throwable");
                }
                _useReflectionToTranslateThrowable = false;
            }
            catch (Throwable throwable2) {
                _log.error((Object)throwable2, throwable2);
                return throwable2;
            }
        }
        if ((className = (clazz = throwable.getClass()).getName()).equals(PortalException.class.getName())) {
            return new PortalException();
        }
        if (className.equals(SystemException.class.getName())) {
            return new SystemException();
        }
        if (className.equals("com.liferay.oauth.OAuthApplicationCallbackURIException")) {
            return new OAuthApplicationCallbackURIException();
        }
        if (className.equals("com.liferay.oauth.OAuthApplicationNameException")) {
            return new OAuthApplicationNameException();
        }
        if (className.equals("com.liferay.oauth.OAuthApplicationWebsiteURLException")) {
            return new OAuthApplicationWebsiteURLException();
        }
        if (className.equals("com.liferay.oauth.NoSuchApplicationException")) {
            return new NoSuchApplicationException();
        }
        if (className.equals("com.liferay.oauth.NoSuchUserException")) {
            return new NoSuchUserException();
        }
        return throwable;
    }

    public static Object translateOutputOAuthApplication(BaseModel<?> oldModel) {
        OAuthApplicationClp newModel = new OAuthApplicationClp();
        newModel.setModelAttributes(oldModel.getModelAttributes());
        newModel.setOAuthApplicationRemoteModel(oldModel);
        return newModel;
    }

    public static Object translateOutputOAuthUser(BaseModel<?> oldModel) {
        OAuthUserClp newModel = new OAuthUserClp();
        newModel.setModelAttributes(oldModel.getModelAttributes());
        newModel.setOAuthUserRemoteModel(oldModel);
        return newModel;
    }
}

