/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.scope.ValidatorProvider;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.CreateException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceNotAcceptedException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.UpdateException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;
import org.gcube.informationsystem.publisher.utils.Utils;
import org.gcube.informationsystem.publisher.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPublisherImpl
implements RegistryPublisher {
    private static final Logger log = LoggerFactory.getLogger(RegistryPublisher.class);
    private static final int REGISTRY_THRESHOLD = 5;
    private RegistryStubs registry = new RegistryStubs();
    private String scopeCreated;

    protected RegistryPublisherImpl() {
    }

    @Override
    public <T extends Resource> T create(T resource) {
        String scope = ScopeProvider.instance.get();
        T res = this.internalCreate(resource, scope);
        this.scopeCreated = scope;
        res = this.update(res);
        return res;
    }

    @Override
    public <T extends Resource> T vosCreate(T resource, List<String> scopes) {
        T res = this.internalVosCreate(resource, scopes);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Resource> T internalVosCreate(T resource, List<String> scopes) {
        log.trace("internalVosCreate method");
        String currentScope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", scopes);
        if (resource.id() == null || resource.id().isEmpty()) {
            String id = UUID.randomUUID().toString();
            log.debug("id generated: " + (String)id);
            ResourceMediator.setId(resource, id);
        }
        for (String scope : scopes) {
            log.debug("[VOCREATE] new scope added {}", (Object)scope);
            ResourceMediator.setScope(resource, scope);
        }
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid ", e.getCause());
        }
        HashSet<String> vosScopes = this.updateResourceScopes(resource);
        try {
            if (currentScope != null) {
                RegistryStub stub;
                String currentVO = Utils.getCurrentVO(currentScope);
                if (currentVO != null) {
                    stub = this.getRegistryStub();
                    this.createResource(resource, currentVO, stub);
                    vosScopes.remove(currentVO);
                } else {
                    stub = this.getRegistryStub();
                    this.createResource(resource, currentScope, stub);
                    vosScopes.remove(currentScope);
                }
            }
            for (String voScope : vosScopes) {
                log.trace("[VOCREATE] resource " + resource.id() + " update in scope {} with scopes {} ", (Object)voScope, (Object)resource.scopes().asCollection());
                ScopeProvider.instance.set(voScope);
                try {
                    RegistryStub stub = this.getRegistryStub();
                    this.createResource(resource, voScope, stub);
                }
                catch (Exception e) {
                    log.error("resource update problem on scope: " + voScope + " try the next scope if any");
                }
                finally {
                    ScopeProvider.instance.set(currentScope);
                }
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        log.trace("[VOCREATE] resource created with scopes {}", (Object)resource.scopes().asCollection());
        return resource;
    }

    private <T extends Resource> T internalCreate(T resource, String scope) {
        log.trace("registry-publisher: create method");
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", scope);
        if (ValidationUtils.isPresent(resource, scope)) {
            throw new IllegalStateException("The scope " + scope + " is already present in the resource. The create operation can't be performed ");
        }
        log.debug("resource id found: " + resource.id());
        if (resource.id() == null || resource.id().isEmpty()) {
            String id = UUID.randomUUID().toString();
            log.debug("id generated: " + id);
            ResourceMediator.setId(resource, id);
        }
        log.debug("scope set in resource: {} ", (Object)scope);
        ResourceMediator.setScope(resource, scope);
        ValidatorProvider.getValidator(resource).checkScopeCompatibility(resource, Arrays.asList(scope));
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid ", e.getCause());
        }
        RegistryStub stub = this.getRegistryStub();
        this.createResource(resource, scope, stub);
        log.trace("resource created in scope {} with scopes {}", (Object)scope, (Object)resource.scopes().asCollection());
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Resource> T update(T resource) {
        log.trace("[UPDATE] update resource with id : " + resource.id());
        String currentScope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        try {
            for (String scope : scopes) {
                log.debug("[UPDATE] check update operation on scope " + scope);
                if (this.scopeCreated == null || this.scopeCreated != null && !this.scopeCreated.equals(scope)) {
                    log.trace("[UPDATE] resource update in scope {} with scopes {} ", (Object)scope, (Object)resource.scopes().asCollection());
                    ScopeProvider.instance.set(scope);
                    this.registryUpdate(resource, tries);
                    tries = 0;
                    continue;
                }
                log.trace("skip updating on scope " + this.scopeCreated);
            }
        }
        finally {
            this.scopeCreated = null;
            ScopeProvider.instance.set(currentScope);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Resource> T vosUpdate(T resource) {
        log.trace("[VOUPDATE] update resource with id : " + resource.id());
        String currentScope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        HashSet<String> vosScopes = Utils.getInternalVOScopes(resource);
        try {
            if (currentScope != null) {
                String currentVO = Utils.getCurrentVO(currentScope);
                if (currentVO != null) {
                    ScopeProvider.instance.set(currentVO);
                    this.registryUpdate(resource, 0);
                    log.debug("currentVO " + currentVO + " updated");
                    vosScopes.remove(currentVO);
                } else {
                    ScopeProvider.instance.set(currentScope);
                    this.registryUpdate(resource, 0);
                    log.debug("currentVO " + currentScope + " is the root-vo");
                    vosScopes.remove(currentScope);
                }
            }
            int tries = 0;
            for (String voScope : vosScopes) {
                log.debug("[VOUPDATE] check update operation on scope {} ", (Object)voScope);
                if (this.scopeCreated == null || this.scopeCreated != null && !this.scopeCreated.equals(voScope)) {
                    log.trace("[VOUPDATE] resource " + resource.id() + " update in scope {} with scopes {} ", (Object)voScope, (Object)resource.scopes().asCollection());
                    try {
                        ScopeProvider.instance.set(voScope);
                        this.registryUpdate(resource, tries);
                        tries = 0;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("resource update problem on scope: " + voScope + " try the next scope if any");
                        continue;
                    }
                    finally {
                        this.scopeCreated = null;
                        ScopeProvider.instance.set(currentScope);
                        continue;
                    }
                }
                log.trace("[VOUPDATE] skip updating on scope {}", (Object)this.scopeCreated);
            }
        }
        finally {
            this.scopeCreated = null;
            ScopeProvider.instance.set(currentScope);
        }
        return resource;
    }

    @Override
    public <T extends Resource> T remove(T resource) {
        String currentScope = ScopeProvider.instance.get();
        log.info(" remove resource with id : " + resource.id() + " from scope: " + currentScope);
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", currentScope);
        this.validateScope(resource);
        this.updateResourceScopes(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        log.info(" remove " + currentScope + " scope from resource " + resource.id());
        ResourceMediator.removeScope(resource, currentScope);
        try {
            this.updateResourceRemoveOperation(resource, currentScope);
        }
        catch (Exception e) {
            ResourceMediator.setScope(resource, currentScope);
            log.error("exception message: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return resource;
    }

    private void registryUpdate(Resource resource, int tries) {
        log.trace("try to update resource with id: " + resource.id() + " times " + (tries + 1) + " on scope: " + ScopeProvider.instance.get());
        try {
            this.registry.getStubs().update(resource.id(), resource.type().toString(), this.toXml(resource));
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (UpdateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            log.warn("Failed update resource on " + this.registry.getEndPoints().get(0) + " times: " + (tries + 1));
            if (tries < 5) {
                ++tries;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.registryUpdate(resource, tries);
            }
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
    }

    private String toXml(Resource resource) {
        StringWriter writer = new StringWriter();
        Resources.marshal((Object)resource, (Writer)writer);
        return writer.toString();
    }

    private void validateScope(Resource resource) {
        ValidatorProvider.getValidator(resource).validate(resource);
    }

    private <T extends Resource> void updateResourceRemoveOperation(T resource, String currentScope) {
        if (!this.isRemoveNeeded(resource, currentScope)) {
            this.vosUpdate(resource);
        } else {
            log.info("the resource have only the " + currentScope + " scope defined. Remove the resource " + resource.id() + " from IC");
            try {
                log.debug("remove from IS scope " + currentScope);
                this.registry.getStubs().remove(resource.id(), resource.type().toString());
            }
            catch (Exception e) {
                log.error("the resource can't be removed ", (Throwable)e);
                throw new IllegalArgumentException("the resource can't be removed from scope " + currentScope, e);
            }
            this.updateResource(resource, currentScope);
        }
    }

    private <T extends Resource> boolean isRemoveNeeded(T resource, String scope) {
        return ValidationUtils.isCompatibleScopeForRemove(resource, scope);
    }

    private <T extends Resource> void createResource(T resource, String scope, RegistryStub stub) {
        try {
            log.info("create resource with id " + resource.id() + " in scope: " + scope);
            String type = null;
            type = resource.type().toString();
            log.info("resource type is: " + type);
            if (resource.type().equals((Object)"ServiceEndpoint")) {
                type = "RuntimeResource";
            }
            stub.create(this.toXml(resource), type);
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (CreateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
        log.info("created resource " + resource.id() + " on scope " + scope);
    }

    private RegistryStub getRegistryStub() {
        RegistryStub stub = null;
        try {
            stub = this.registry.getStubs();
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Resource> void updateResource(T resource, String currentScope) {
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        try {
            for (String scope : scopes) {
                ScopeProvider.instance.set(scope);
                this.registryUpdate(resource, tries);
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Resource> void updateResourceVOLevel(T resource, List<String> voScopes, String currentScope) {
        int tries = 0;
        try {
            for (String scope : voScopes) {
                ScopeProvider.instance.set(scope);
                this.registryUpdate(resource, tries);
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
    }

    private <T extends Resource> HashSet<String> updateResourceScopes(T resource) {
        HashSet<String> vosScopes = Utils.getInternalVOScopes(resource);
        if (resource.type().toString().equalsIgnoreCase("RunningInstance") || resource.type().toString().equalsIgnoreCase("GHN") || resource.type().toString().equalsIgnoreCase("GCoreEndpoint") || resource.type().toString().equalsIgnoreCase("HostingNode")) {
            return vosScopes;
        }
        List<String> latestScopesFound = Utils.setLatestInternalScopes(resource, vosScopes);
        log.debug("latest scope found are " + latestScopesFound);
        if (latestScopesFound == null || latestScopesFound.isEmpty()) {
            latestScopesFound = new ArrayList<String>(vosScopes.size());
            for (String scope : vosScopes) {
                latestScopesFound.add(scope);
            }
        } else {
            ResourceMediator.cleanAllScopes(resource);
            for (String scope : latestScopesFound) {
                log.debug("[VOCREATE] scope added {}", (Object)scope);
                ResourceMediator.setScope(resource, scope);
                ScopeBean scopeBean = new ScopeBean(scope);
                if (scopeBean.is(ScopeBean.Type.VRE) || vosScopes.contains(scope)) continue;
                vosScopes.add(scope);
            }
        }
        return vosScopes;
    }
}

