/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.im4java.core.CommandException;
import org.im4java.core.DynamicOperation;
import org.im4java.core.IM4JavaException;
import org.im4java.core.Operation;
import org.im4java.process.ErrorConsumer;
import org.im4java.process.ProcessStarter;
import org.im4java.process.ProcessTask;
import org.im4java.process.StandardStream;
import org.im4java.script.BashScriptGenerator;
import org.im4java.script.CmdScriptGenerator;
import org.im4java.script.ScriptGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCommand
extends ProcessStarter
implements ErrorConsumer {
    private LinkedList<String> iCommands = new LinkedList();
    private ArrayList<String> iErrorText;
    private LinkedList<String> iTmpFiles = new LinkedList();
    private static ScriptGenerator iDefaultScriptGenerator = System.getProperty("os.name").startsWith("Windows") ? new CmdScriptGenerator() : new BashScriptGenerator();
    private ScriptGenerator iScriptGenerator = null;

    public ImageCommand() {
        this.setOutputConsumer(StandardStream.STDOUT);
        this.setErrorConsumer(this);
    }

    public ImageCommand(String ... stringArray) {
        this();
        this.setCommand(stringArray);
    }

    public void setCommand(String ... stringArray) {
        for (String string : stringArray) {
            this.iCommands.add(string);
        }
    }

    public LinkedList<String> getCommand() {
        return this.iCommands;
    }

    public ArrayList<String> getErrorText() {
        return this.iErrorText;
    }

    private LinkedList<String> prepareArguments(Operation operation, Object ... objectArray) throws IOException, IM4JavaException {
        LinkedList<String> linkedList = new LinkedList<String>(operation.getCmdArgs());
        linkedList.addAll(0, this.iCommands);
        this.resolveImages(linkedList, objectArray);
        this.resolveDynamicOperations(operation, linkedList, objectArray);
        return linkedList;
    }

    public void run(Operation operation, Object ... objectArray) throws IOException, InterruptedException, IM4JavaException {
        LinkedList<String> linkedList = this.prepareArguments(operation, objectArray);
        try {
            this.run(linkedList);
        }
        catch (Exception exception) {
            this.removeTmpFiles();
            CommandException commandException = new CommandException(exception);
            commandException.fillInStackTrace();
            throw commandException;
        }
    }

    public ProcessTask getProcessTask(Operation operation, Object ... objectArray) throws IOException, IM4JavaException {
        LinkedList<String> linkedList = this.prepareArguments(operation, objectArray);
        return this.getProcessTask(linkedList);
    }

    @Override
    protected void finished(int n) throws Exception {
        if (n > 0) {
            CommandException commandException = this.iErrorText.size() > 0 ? new CommandException(this.iErrorText.get(0)) : new CommandException("return code: " + n);
            commandException.setErrorText(this.iErrorText);
            commandException.setReturnCode(n);
            throw commandException;
        }
        this.removeTmpFiles();
    }

    private void resolveImages(LinkedList<String> linkedList, Object ... objectArray) throws IOException {
        ListIterator<String> listIterator = linkedList.listIterator();
        int n = 0;
        boolean bl = false;
        String string = null;
        for (Object object : objectArray) {
            String string2;
            bl = false;
            while (listIterator.hasNext()) {
                string = (String)listIterator.next();
                if (!string.startsWith("?img?")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("more argument images than placeholders!");
            }
            if (object instanceof String) {
                if (string.length() == "?img?".length()) {
                    listIterator.set((String)object);
                } else {
                    string2 = string.substring("?img?".length());
                    listIterator.set((String)object + string2);
                }
            } else if (object instanceof BufferedImage) {
                string2 = this.convert2TmpFile((BufferedImage)object);
                listIterator.set(string2);
                this.iTmpFiles.add(string2);
            } else {
                throw new IllegalArgumentException(object.getClass().getName() + " is an unsupported image-type");
            }
            ++n;
        }
    }

    private void resolveDynamicOperations(Operation operation, LinkedList<String> linkedList, Object ... objectArray) throws IM4JavaException {
        ListIterator<String> listIterator = linkedList.listIterator();
        ListIterator listIterator2 = operation.getDynamicOperations().listIterator();
        while (listIterator2.hasNext()) {
            DynamicOperation dynamicOperation = (DynamicOperation)listIterator2.next();
            Operation operation2 = dynamicOperation.resolveOperation(objectArray);
            while (listIterator.hasNext() && !((String)listIterator.next()).equals("?dop?")) {
            }
            if (operation2 == null) {
                listIterator.remove();
                continue;
            }
            LinkedList<String> linkedList2 = dynamicOperation.resolveOperation(objectArray).getCmdArgs();
            if (linkedList2 == null) {
                listIterator.remove();
                continue;
            }
            listIterator.remove();
            for (String string : linkedList2) {
                listIterator.add(string);
            }
        }
    }

    @Override
    public void consumeError(InputStream inputStream) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.iErrorText = new ArrayList();
        while ((string = bufferedReader.readLine()) != null) {
            this.iErrorText.add(string);
        }
        bufferedReader.close();
        inputStreamReader.close();
    }

    private String getTmpFile() throws IOException {
        File file = File.createTempFile("im4java-", ".png");
        file.deleteOnExit();
        return file.getAbsolutePath();
    }

    private String convert2TmpFile(BufferedImage bufferedImage) throws IOException {
        String string = this.getTmpFile();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string));
        return string;
    }

    private void removeTmpFiles() {
        for (String string : this.iTmpFiles) {
            try {
                new File(string).delete();
            }
            catch (Exception exception) {}
        }
    }

    public static void setDefaultScriptGenerator(ScriptGenerator scriptGenerator) {
        iDefaultScriptGenerator = scriptGenerator;
    }

    public void setScriptGenerator(ScriptGenerator scriptGenerator) {
        this.iScriptGenerator = scriptGenerator;
    }

    public void createScript(PrintWriter printWriter, Operation operation, Properties properties) {
        String string2;
        ScriptGenerator scriptGenerator = this.iScriptGenerator;
        if (scriptGenerator == null) {
            scriptGenerator = iDefaultScriptGenerator;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.getCommand()) {
            stringBuilder.append(string2).append(' ');
        }
        properties.setProperty("im4java.cmd", stringBuilder.toString());
        Object object = ImageCommand.getGlobalSearchPath();
        if (object == null) {
            object = "";
        }
        if ((string2 = this.getSearchPath()) == null) {
            string2 = "";
        }
        properties.setProperty("im4java.globalSearchPath", (String)object);
        properties.setProperty("im4java.localSearchPath", string2);
        scriptGenerator.init(printWriter, operation, properties);
        scriptGenerator.createScript();
    }

    public void createScript(String string, Operation operation, Properties properties) throws FileNotFoundException {
        if (System.getProperty("os.name").startsWith("Windows")) {
            string = string + ".cmd";
        }
        PrintWriter printWriter = new PrintWriter(string);
        this.createScript(printWriter, operation, properties);
        printWriter.close();
    }

    public void createScript(String string, Operation operation) throws FileNotFoundException {
        this.createScript(string, operation, new Properties());
    }
}

