/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.test;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.im4java.core.ConvertCmd;
import org.im4java.core.DisplayCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.ImageCommand;
import org.im4java.process.Pipe;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessEventListener;
import org.im4java.process.ProcessTask;
import org.im4java.test.AbstractTestCase;

public class TestCase23
extends AbstractTestCase
implements ProcessEventListener {
    private ConvertCmd iCmd1;
    private ConvertCmd iCmd2;
    private IMOperation iOp1;
    private IMOperation iOp2;
    private PipedInputStream iPis;
    private PipedOutputStream iPos;

    public String getDescription() {
        return "chaining of commands";
    }

    public static void main(String[] stringArray) {
        TestCase23 testCase23 = new TestCase23();
        testCase23.runTest(stringArray);
    }

    public void run() throws Exception {
        int n;
        System.err.println("23. Testing chaining of commands ...");
        String string = "sync1";
        if (this.iArgs != null && this.iArgs.length > 0) {
            string = this.iArgs[0];
        }
        int n2 = 0;
        if (this.iArgs != null && this.iArgs.length > 1) {
            n2 = Integer.parseInt(this.iArgs[1]);
        }
        this.iPis = new PipedInputStream();
        this.iPos = new PipedOutputStream(this.iPis);
        Pipe pipe = new Pipe(null, this.iPos);
        Pipe pipe2 = new Pipe(this.iPis, null);
        this.iOp1 = new IMOperation();
        this.iOp1.addImage(iImageDir + "ipomoea.jpg");
        this.iOp1.resize((Integer)200, null, Character.valueOf('%'));
        if (n2 == 1) {
            this.iOp1.rotate();
        }
        this.iOp1.addImage("tif:-");
        this.iCmd1 = new ConvertCmd();
        this.iCmd1.setOutputConsumer(pipe);
        this.iCmd1.addProcessEventListener(this);
        this.iOp2 = new IMOperation();
        this.iOp2.addImage("tif:-");
        this.iOp2.rotate(90.0);
        if (n2 == 2) {
            this.iOp2.resize();
        }
        this.iOp2.addImage(iImageDir + "ipomoea-large.jpg");
        this.iCmd2 = new ConvertCmd();
        this.iCmd2.setInputProvider(pipe2);
        if (string.equals("sync1")) {
            n = this.sync1();
        } else if (string.equals("sync2")) {
            n = this.sync2();
        } else {
            System.err.println("error: illegal sync-type");
            n = 1;
        }
        if (n == 0) {
            DisplayCmd.show(iImageDir + "ipomoea-large.jpg");
        }
    }

    private int sync1() throws Exception {
        this.iCmd2.setAsyncMode(true);
        ProcessTask processTask = this.iCmd2.getProcessTask(this.iOp2, new Object[0]);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(processTask);
        executorService.shutdown();
        try {
            this.iCmd1.run(this.iOp1, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.iPos.close();
            this.iPis.close();
        }
        int n = ((ProcessEvent)processTask.get()).getReturnCode();
        if (n > 0) {
            System.err.println("Problem with cmd2. Trying to shutdown execution...");
            processTask.cancel(true);
            executorService.shutdownNow();
            System.err.println("process cmd2 terminated");
        }
        return n;
    }

    private int sync2() throws Exception {
        this.iCmd1.setAsyncMode(true);
        ProcessTask processTask = this.iCmd1.getProcessTask(this.iOp1, new Object[0]);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(processTask);
        executorService.shutdown();
        this.iCmd2.run(this.iOp2, new Object[0]);
        int n = ((ProcessEvent)processTask.get()).getReturnCode();
        if (n > 0) {
            System.err.println("Problem with cmd1. Trying to shutdown execution...");
            processTask.cancel(true);
            executorService.shutdownNow();
            System.err.println("process cmd1 terminated");
        }
        return n;
    }

    public void processInitiated(ProcessEvent processEvent) {
    }

    public void processStarted(ProcessEvent processEvent) {
    }

    public void processTerminated(ProcessEvent processEvent) {
        if (processEvent.getReturnCode() != 0) {
            System.err.println("problem with cmd1");
            ImageCommand imageCommand = (ImageCommand)processEvent.getProcessStarter();
            ArrayList<String> arrayList = imageCommand.getErrorText();
            if (arrayList != null && arrayList.size() > 0) {
                System.err.println("  printing errors:");
                for (String string : arrayList) {
                    System.err.println("  " + string);
                }
            }
            try {
                this.iPos.close();
                this.iPis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

