/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.utils;

import java.io.File;

public class FilenamePatternResolver {
    private String iTemplate;
    private char iEscChar;

    public FilenamePatternResolver(String string) {
        this(string, '%');
    }

    public FilenamePatternResolver(String string, char c) {
        this.iTemplate = string;
        this.iEscChar = c;
    }

    public String createName(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.iTemplate);
        File file = new File(string);
        int n = stringBuilder.indexOf(this.iEscChar + "D");
        if (n > -1) {
            stringBuilder.replace(n, n + 2, this.getDrive(file));
        }
        if ((n = stringBuilder.indexOf(this.iEscChar + "P")) > -1) {
            stringBuilder.replace(n, n + 2, this.getFullpath(file));
        }
        if ((n = stringBuilder.indexOf(this.iEscChar + "p")) > -1) {
            stringBuilder.replace(n, n + 2, this.getPath(file));
        }
        if ((n = stringBuilder.indexOf(this.iEscChar + "F")) > -1) {
            stringBuilder.replace(n, n + 2, this.getFullname(file));
        }
        if ((n = stringBuilder.indexOf(this.iEscChar + "f")) > -1) {
            stringBuilder.replace(n, n + 2, this.getName(file));
        }
        if ((n = stringBuilder.indexOf(this.iEscChar + "e")) > -1) {
            stringBuilder.replace(n, n + 2, this.getExt(file));
        }
        return stringBuilder.toString();
    }

    public String getDrive(File file) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String string = file.getAbsolutePath();
            if (string == null) {
                return "";
            }
            return string.substring(0, 1);
        }
        return "";
    }

    public String getFullpath(File file) {
        String string = file.getParent();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getPath(File file) {
        String string = file.getParent();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(File.separatorChar);
        if (n == string.length() - 1) {
            n = string.lastIndexOf(File.separatorChar, n);
        }
        return string.substring(n + 1);
    }

    public String getFullname(File file) {
        String string = file.getName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getName(File file) {
        String string = file.getName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getExt(File file) {
        String string = file.getName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return "";
    }
}

