/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.BuildException;

public class ProjectBuildOrderTask
extends BaseTask {
    private static final String PROP_BUILD_ORDER = "buildorder";
    private String separator = ",";
    private File workspaceLocation;

    public void execute() throws BuildException {
        try {
            Collection<Project> projects;
            if (this.workspaceLocation == null) {
                throw new BuildException("The given workspace dir is not set");
            }
            if (!this.workspaceLocation.isDirectory()) {
                throw new BuildException("The given workspace dir  not exist " + this.workspaceLocation);
            }
            try {
                this.workspaceLocation = this.workspaceLocation.getCanonicalFile();
                Workspace workspace = Workspace.getWorkspace(this.workspaceLocation);
                projects = workspace.getBuildOrder();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (Project project : projects) {
                sb.append(sep);
                sb.append(project.getName());
                sep = this.separator;
            }
            this.getProject().setProperty(PROP_BUILD_ORDER, sb.toString());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setWorkspaceLocation(File workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }
}

