/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.json;

import aQute.lib.json.Decoder;
import aQute.lib.json.Encoder;
import aQute.lib.json.Handler;
import aQute.lib.json.StringHandler;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHandler
extends Handler {
    final Class<?> rawClass;
    final Type keyType;
    final Type valueType;

    MapHandler(Class<?> rawClass, Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        if (rawClass.isInterface()) {
            if (rawClass.isAssignableFrom(HashMap.class)) {
                rawClass = HashMap.class;
            } else if (rawClass.isAssignableFrom(TreeMap.class)) {
                rawClass = TreeMap.class;
            } else if (rawClass.isAssignableFrom(Hashtable.class)) {
                rawClass = Hashtable.class;
            } else if (rawClass.isAssignableFrom(LinkedHashMap.class)) {
                rawClass = LinkedHashMap.class;
            } else if (rawClass.isAssignableFrom(Dictionary.class)) {
                rawClass = Hashtable.class;
            } else {
                throw new IllegalArgumentException("Unknown map interface: " + rawClass);
            }
        }
        this.rawClass = rawClass;
    }

    @Override
    void encode(Encoder app, Object object, Map<Object, Type> visited) throws IOException, Exception {
        Map map = (Map)object;
        app.append("{");
        String del = "";
        for (Map.Entry e : map.entrySet()) {
            app.append(del);
            String key = e.getKey() != null && (this.keyType == String.class || this.keyType == Object.class) ? e.getKey().toString() : app.codec.enc().put(e.getKey()).toString();
            StringHandler.string(app, key);
            app.append(":");
            app.encode(e.getValue(), this.valueType, visited);
            del = ",";
        }
        app.append("}");
    }

    @Override
    Object decodeObject(Decoder r) throws Exception {
        assert (r.current() == 123);
        Map map = (Map)this.rawClass.newInstance();
        int c = r.next();
        while ("[{\"-0123456789tfn".indexOf(c) >= 0) {
            Object key = r.codec.parseString(r);
            if (this.keyType != null && this.keyType != Object.class) {
                Handler h = r.codec.getHandler(this.keyType);
                key = h.decode(r, (String)key);
            }
            if ((c = r.skipWs()) != 58) {
                throw new IllegalArgumentException("Expected ':' but got " + (char)c);
            }
            c = r.next();
            Object value = r.codec.decode(this.valueType, r);
            if (value != null || !r.codec.ignorenull) {
                map.put(key, value);
            }
            if ((c = r.skipWs()) == 125) break;
            if (c == 44) {
                c = r.next();
                continue;
            }
            throw new IllegalArgumentException("Invalid character in parsing list, expected } or , but found " + (char)c);
        }
        assert (r.current() == 125);
        r.read();
        return map;
    }
}

