/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.icclient.stubs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.icclient.stubs.CollectorStub;
import org.gcube.resources.discovery.icclient.stubs.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorStubRestImpl
implements CollectorStub {
    private static Logger log = LoggerFactory.getLogger(CollectorStubRestImpl.class);
    public static final String TOKEN_HEADER_ENTRY = "gcube-token";
    public static final String SCOPE_HEADER_ENTRY = "gcube-scope";
    private String endopoint;

    public CollectorStubRestImpl(String endopoint) {
        this.endopoint = endopoint;
    }

    @Override
    public String execute(String query) throws MalformedQueryException {
        String queryParameter = "query";
        try {
            String toReturn;
            StringBuilder callUrl = new StringBuilder(this.endopoint).append("?").append("query").append("=").append(URLEncoder.encode(query, StandardCharsets.UTF_8.toString()));
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.makeRequest(url, "GET", false);
            connection.setDoInput(true);
            if (connection.getResponseCode() != 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                Throwable throwable = null;
                try {
                    try {
                        String line;
                        StringBuilder error = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            error.append(line);
                        }
                        throw new Exception("error executing query: " + error.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            reader.close();
                        }
                    }
                    throw throwable3;
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
                String line;
                StringBuilder result = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
                toReturn = result.toString();
            }
            return toReturn;
        }
        catch (Exception e) {
            log.error("error executing query", (Throwable)e);
            throw new MalformedQueryException(e.getMessage());
        }
    }

    private HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception {
        HttpURLConnection connection = url.toString().startsWith("https://") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
        if (includeTokenInHeader) {
            if (SecurityTokenProvider.instance.get() == null) {
                throw new RuntimeException("null token passed");
            }
            connection.setRequestProperty(TOKEN_HEADER_ENTRY, SecurityTokenProvider.instance.get());
        } else {
            if (ScopeProvider.instance.get() == null) {
                throw new RuntimeException("null scope passed");
            }
            connection.setRequestProperty(SCOPE_HEADER_ENTRY, ScopeProvider.instance.get());
        }
        connection.setRequestMethod(method);
        return connection;
    }
}

