/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.core.cache.Cache;
import org.apache.jackrabbit.core.cache.CacheAccessListener;

public abstract class AbstractCache
implements Cache {
    private final AtomicLong memoryUsed = new AtomicLong();
    private final AtomicLong maxMemorySize = new AtomicLong();
    private final AtomicInteger accessCount = new AtomicInteger();
    private final AtomicReference<CacheAccessListener> accessListener = new AtomicReference();

    protected boolean isTooBig() {
        return this.memoryUsed.get() > this.maxMemorySize.get();
    }

    protected void recordSizeChange(long delta) {
        this.memoryUsed.addAndGet(delta);
    }

    protected void recordCacheAccess() {
        CacheAccessListener listener;
        int count = this.accessCount.incrementAndGet();
        if (count % 127 == 0 && (listener = this.accessListener.get()) != null) {
            listener.cacheAccessed();
        }
    }

    public long getAccessCount() {
        return this.accessCount.get();
    }

    public void resetAccessCount() {
        this.accessCount.set(0);
    }

    public long getMemoryUsed() {
        return this.memoryUsed.get();
    }

    public long getMaxMemorySize() {
        return this.maxMemorySize.get();
    }

    public void setMaxMemorySize(long size) {
        this.maxMemorySize.set(size);
    }

    public void setAccessListener(CacheAccessListener listener) {
        this.accessListener.set(listener);
    }

    public void dispose() {
        CacheAccessListener listener = this.accessListener.get();
        if (listener != null) {
            listener.disposeCache(this);
        }
    }
}

